/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluids;

public class DoublePlantBlock
extends BushBlock {
    public static final MapCodec<DoublePlantBlock> CODEC = DoublePlantBlock.simpleCodec(DoublePlantBlock::new);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public MapCodec<? extends DoublePlantBlock> codec() {
        return CODEC;
    }

    public DoublePlantBlock(BlockBehaviour.Properties p_52861_) {
        super(p_52861_);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, DoubleBlockHalf.LOWER));
    }

    @Override
    protected BlockState updateShape(BlockState p_52894_, Direction p_52895_, BlockState p_52896_, LevelAccessor p_52897_, BlockPos p_52898_, BlockPos p_52899_) {
        DoubleBlockHalf $$6 = p_52894_.getValue(HALF);
        if (!(p_52895_.getAxis() != Direction.Axis.Y || $$6 == DoubleBlockHalf.LOWER != (p_52895_ == Direction.UP) || p_52896_.is(this) && p_52896_.getValue(HALF) != $$6)) {
            return Blocks.AIR.defaultBlockState();
        }
        if ($$6 == DoubleBlockHalf.LOWER && p_52895_ == Direction.DOWN && !p_52894_.canSurvive(p_52897_, p_52898_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_52894_, p_52895_, p_52896_, p_52897_, p_52898_, p_52899_);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_52863_) {
        BlockPos $$1 = p_52863_.getClickedPos();
        Level $$2 = p_52863_.getLevel();
        if ($$1.getY() < $$2.getMaxBuildHeight() - 1 && $$2.getBlockState($$1.above()).canBeReplaced(p_52863_)) {
            return super.getStateForPlacement(p_52863_);
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level p_52872_, BlockPos p_52873_, BlockState p_52874_, LivingEntity p_52875_, ItemStack p_52876_) {
        BlockPos $$5 = p_52873_.above();
        p_52872_.setBlock($$5, DoublePlantBlock.copyWaterloggedFrom(p_52872_, $$5, (BlockState)this.defaultBlockState().setValue(HALF, DoubleBlockHalf.UPPER)), 3);
    }

    @Override
    protected boolean canSurvive(BlockState p_52887_, LevelReader p_52888_, BlockPos p_52889_) {
        if (p_52887_.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockState $$3 = p_52888_.getBlockState(p_52889_.below());
            return $$3.is(this) && $$3.getValue(HALF) == DoubleBlockHalf.LOWER;
        }
        return super.canSurvive(p_52887_, p_52888_, p_52889_);
    }

    public static void placeAt(LevelAccessor p_153174_, BlockState p_153175_, BlockPos p_153176_, int p_153177_) {
        BlockPos $$4 = p_153176_.above();
        p_153174_.setBlock(p_153176_, DoublePlantBlock.copyWaterloggedFrom(p_153174_, p_153176_, (BlockState)p_153175_.setValue(HALF, DoubleBlockHalf.LOWER)), p_153177_);
        p_153174_.setBlock($$4, DoublePlantBlock.copyWaterloggedFrom(p_153174_, $$4, (BlockState)p_153175_.setValue(HALF, DoubleBlockHalf.UPPER)), p_153177_);
    }

    public static BlockState copyWaterloggedFrom(LevelReader p_182454_, BlockPos p_182455_, BlockState p_182456_) {
        if (p_182456_.hasProperty(BlockStateProperties.WATERLOGGED)) {
            return (BlockState)p_182456_.setValue(BlockStateProperties.WATERLOGGED, p_182454_.isWaterAt(p_182455_));
        }
        return p_182456_;
    }

    @Override
    public BlockState playerWillDestroy(Level p_52878_, BlockPos p_52879_, BlockState p_52880_, Player p_52881_) {
        if (!p_52878_.isClientSide) {
            if (p_52881_.isCreative()) {
                DoublePlantBlock.preventDropFromBottomPart(p_52878_, p_52879_, p_52880_, p_52881_);
            } else {
                DoublePlantBlock.dropResources(p_52880_, p_52878_, p_52879_, null, p_52881_, p_52881_.getMainHandItem());
            }
        }
        return super.playerWillDestroy(p_52878_, p_52879_, p_52880_, p_52881_);
    }

    @Override
    public void playerDestroy(Level p_52865_, Player p_52866_, BlockPos p_52867_, BlockState p_52868_, @Nullable BlockEntity p_52869_, ItemStack p_52870_) {
        super.playerDestroy(p_52865_, p_52866_, p_52867_, Blocks.AIR.defaultBlockState(), p_52869_, p_52870_);
    }

    protected static void preventDropFromBottomPart(Level p_52904_, BlockPos p_52905_, BlockState p_52906_, Player p_52907_) {
        BlockPos $$5;
        BlockState $$6;
        DoubleBlockHalf $$4 = p_52906_.getValue(HALF);
        if ($$4 == DoubleBlockHalf.UPPER && ($$6 = p_52904_.getBlockState($$5 = p_52905_.below())).is(p_52906_.getBlock()) && $$6.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState $$7 = $$6.getFluidState().is(Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            p_52904_.setBlock($$5, $$7, 35);
            p_52904_.levelEvent(p_52907_, 2001, $$5, Block.getId($$6));
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_52901_) {
        p_52901_.add(HALF);
    }

    @Override
    protected long getSeed(BlockState p_52891_, BlockPos p_52892_) {
        return Mth.getSeed(p_52892_.getX(), p_52892_.below(p_52891_.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), p_52892_.getZ());
    }
}

