/*
 * Decompiled with CFR 0.152.
 */
package com.haruhakugit.hdskinsupport;

import com.mojang.blaze3d.platform.NativeImage;
import net.neoforged.fml.common.Mod;

@Mod(value="hdskinsupport")
public final class HDSkinSupport {
    public static final String MOD_ID = "hdskinsupport";

    public static NativeImage processLegacySkin(NativeImage nativeImageIn) {
        if (nativeImageIn == null) {
            return null;
        }
        int imageWidth = nativeImageIn.getWidth();
        int imageHeight = nativeImageIn.getHeight();
        boolean flag = imageHeight == imageWidth / 2;
        float scaleFactor = 0.015625f * (float)imageWidth;
        if (flag) {
            NativeImage nativeimage = new NativeImage(imageWidth, imageWidth, true);
            nativeimage.copyFrom(nativeImageIn);
            nativeImageIn.close();
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 4, 16, 16, 32, 4, 4, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 8, 16, 16, 32, 4, 4, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 0, 20, 24, 32, 4, 12, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 4, 20, 16, 32, 4, 12, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 8, 20, 8, 32, 4, 12, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 12, 20, 16, 32, 4, 12, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 44, 16, -8, 32, 4, 4, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 48, 16, -8, 32, 4, 4, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 40, 20, 0, 32, 4, 12, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 44, 20, -8, 32, 4, 12, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 48, 20, -16, 32, 4, 12, true, false, scaleFactor);
            HDSkinSupport.copyAreaRGBAScale(nativeimage, 52, 20, -8, 32, 4, 12, true, false, scaleFactor);
            nativeImageIn = nativeimage;
        }
        if (flag) {
            HDSkinSupport.setTransparent(nativeImageIn, 32, 0, (int)(64.0f * scaleFactor), (int)(32.0f * scaleFactor));
        }
        return nativeImageIn;
    }

    private static void copyAreaRGBAScale(NativeImage nativeimage, int xFrom, int yFrom, int xToDelta, int yToDelta, int widthIn, int heightIn, boolean mirrorX, boolean mirrorY, float scaleFactor) {
        nativeimage.copyRect((int)((float)xFrom * scaleFactor), (int)((float)yFrom * scaleFactor), (int)((float)xToDelta * scaleFactor), (int)((float)yToDelta * scaleFactor), (int)((float)widthIn * scaleFactor), (int)((float)heightIn * scaleFactor), mirrorX, mirrorY);
    }

    private static void setTransparent(NativeImage image, int x, int y, int width, int height) {
        int j;
        int i;
        for (i = x; i < width; ++i) {
            for (j = y; j < height; ++j) {
                int pixelRGBA = image.getPixelRGBA(i, j);
                if ((pixelRGBA >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (i = x; i < width; ++i) {
            for (j = y; j < height; ++j) {
                image.setPixelRGBA(i, j, image.getPixelRGBA(i, j) & 0xFFFFFF);
            }
        }
    }
}

