/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item.rule.file;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.anti_ad.mc.common.TellPlayer;
import org.anti_ad.mc.common.util.IndentedData;
import org.anti_ad.mc.common.util.IndentedDataFileParser;
import org.anti_ad.mc.ipnext.Log;
import org.anti_ad.mc.ipnext.item.rule.file.RuleDefinition;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFilePreprocessManagerKt;
import org.anti_ad.mc.ipnext.parser.RuleParser;
import org.anti_ad.mc.ipnext.parser.SyntaxErrorException;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nRuleFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleFile.kt\norg/anti_ad/mc/ipnext/item/rule/file/RuleFile\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,72:1\n382#2,7:73\n126#3:80\n153#3,3:81\n*S KotlinDebug\n*F\n+ 1 RuleFile.kt\norg/anti_ad/mc/ipnext/item/rule/file/RuleFile\n*L\n52#1:73,7\n67#1:80\n67#1:81,3\n*E\n"})
public final class RuleFile {
    @NotNull
    private final String fileName;
    @NotNull
    private final String content;
    private final boolean fromUserInput;
    @NotNull
    private final Map rulesMap;

    public RuleFile(@NotNull String string, @NotNull String string2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.fileName = string;
        this.content = string2;
        this.fromUserInput = bl;
        this.rulesMap = new LinkedHashMap();
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Map getRulesMap() {
        return this.rulesMap;
    }

    public final void parseContent() {
        Log.INSTANCE.trace("[-] Parsing file " + this.fileName);
        for (IndentedData indentedData : IndentedDataFileParser.Companion.parse$default((IndentedDataFileParser.Companion)IndentedDataFileParser.Companion, (List)RuleFilePreprocessManagerKt.preprocessRules(StringsKt.lines((CharSequence)this.content)), (String)this.fileName, (int)0, (int)4, null).getSubData()) {
            Log.INSTANCE.trace("    - parsing rule: " + indentedData.getText());
            try {
                RuleDefinition ruleDefinition = RuleParser.INSTANCE.parseRuleDefinition(indentedData);
                Map map = this.rulesMap;
                String string = ruleDefinition.getRuleName();
                Object object = map.get(string);
                if (object == null) {
                    object = new ArrayList();
                    map.put(string, object);
                }
                ((List)object).add(ruleDefinition);
            }
            catch (SyntaxErrorException syntaxErrorException) {
                TellPlayer.INSTANCE.chat("Loading sort rules failed!");
                TellPlayer.INSTANCE.chat("Syntax error in '" + this.fileName + "' (" + indentedData.getText() + ")");
                TellPlayer.INSTANCE.chat("  > at: " + syntaxErrorException.getLine() + ":" + syntaxErrorException.getPos() + " " + syntaxErrorException.getMsg());
                TellPlayer.INSTANCE.chat("");
                TellPlayer.INSTANCE.chat("For more information see logs.");
                Log.INSTANCE.warn("Syntax error in '" + this.fileName + "' (" + indentedData.getText() + ")");
                Log.INSTANCE.warn("  > at: " + syntaxErrorException.getLine() + ":" + syntaxErrorException.getPos() + " " + syntaxErrorException.getMsg());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Log.INSTANCE.trace(() -> RuleFile.parseContent$lambda$1(this));
        Log.INSTANCE.trace("    " + this.fileName + " parse finished");
    }

    private static final String parseContent$lambda$1(RuleFile iterator) {
        Object object;
        iterator = ((RuleFile)((Object)iterator)).rulesMap;
        int n2 = CollectionsKt.flatten((Iterable)((RuleFile)((Object)iterator)).rulesMap.values()).size();
        Iterator iterator2 = iterator;
        iterator = new ArrayList(iterator.size());
        for (Map.Entry entry : iterator2.entrySet()) {
            object = iterator;
            String string = (String)entry.getKey();
            List object2 = (List)entry.getValue();
            object.add(object2.size() == 1 ? string : string + " x" + object2.size());
        }
        object = (List)((Object)iterator);
        return "    Added " + n2 + " rules: " + (List)object;
    }
}

