/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.justahuman.more_cobblemon_tweaks.Hooks;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public final class MoreCobblemonTweaks {
    public static final String MOD_ID = "more_cobblemon_tweaks";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static File configFile;

    public static void initClient(File configFile, Function<String, Boolean> modEnabledFunction, Function<String, String> modVersionFunction) {
        LOGGER.info("Starting MoreCobblemonTweaks");
        MoreCobblemonTweaks.configFile = configFile;
        Utils.setModEnabledFunction(modEnabledFunction);
        Utils.setModVersionFunction(modVersionFunction);
        if (Hooks.cobbreedingPresent()) {
            if (Hooks.cobbreedingCompat()) {
                LOGGER.info(">> Cobbreeding support enabled");
            } else {
                LOGGER.warn(">> Cobbreeding version is not compatible! Cobbreeding support disabled.");
            }
        }
    }

    public static void onReload(ResourceManager manager) {
        ModConfig.loadFromFile();
        PackRepository resourcePackManager = Minecraft.getInstance().getResourcePackRepository();
        List<String> serverPackIds = resourcePackManager.getSelectedPacks().stream().filter(pack -> pack.getPackSource() == PackSource.SERVER).map(Pack::getId).toList();
        for (Map.Entry entry : manager.listResourceStacks("config", identifier -> identifier.getPath().equals("config/more_cobblemon_tweaks.json")).entrySet()) {
            for (Resource resource : (List)entry.getValue()) {
                if (!serverPackIds.contains(resource.sourcePackId())) continue;
                try {
                    ModConfig.loadServerConfig(resource.openAsReader());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load server config file \"{}\" from pack \"{}\"", entry.getKey(), (Object)resource.sourcePackId());
                    LOGGER.error("Error: ", (Throwable)e);
                }
            }
        }
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.tryBuild((String)MOD_ID, (String)path);
    }

    public static File getConfigFile() {
        return configFile;
    }
}

