/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.egg;

import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.List;
import ludichat.cobbreeding.PokemonEgg;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.LoreEnhancements;
import me.justahuman.more_cobblemon_tweaks.features.egg.EncryptedEggLore;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CobbreedingIntegration
extends EnhancedEggLore {
    private final PokemonProperties properties;
    private final IVs ivs;

    public CobbreedingIntegration(String eggInfo) {
        this(PokemonProperties.Companion.parse(eggInfo));
    }

    public CobbreedingIntegration(PokemonProperties properties) {
        this.properties = properties;
        this.ivs = properties.getIvs();
    }

    @Override
    public Component getName(List<Component> lore) {
        if (lore.size() > 2) {
            String name = lore.remove(1).getString();
            if (name.equals("Bad egg")) {
                return Component.literal((String)"Bad Egg");
            }
            return Component.literal((String)(name + " Egg"));
        }
        return super.getName(lore);
    }

    @Override
    public boolean isShiny() {
        return Boolean.TRUE.equals(this.properties.getShiny());
    }

    @Override
    public String getGender() {
        Gender gender = this.properties.getGender();
        return gender == null ? null : gender.name();
    }

    @Override
    public List<Component> getHatchProgress(List<Component> lore) {
        String hatchProgress;
        String[] parts;
        if (lore.size() > 1 && (parts = (hatchProgress = lore.get(1).getString()).split(":")).length == 2) {
            try {
                int minutes = Integer.parseInt(parts[0].trim());
                int seconds = Integer.parseInt(parts[1].trim());
                lore.remove(1);
                return List.of(LoreEnhancements.translate("egg.cobbreeding.hatch_progress", minutes, seconds));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getNature() {
        String natureId = this.properties.getNature();
        if (natureId == null) {
            return null;
        }
        ResourceLocation id = natureId.contains(":") ? ResourceLocation.tryParse((String)natureId) : MiscUtilsKt.cobblemonResource((String)natureId);
        Nature nature = id == null ? null : Natures.getNature((ResourceLocation)id);
        return nature == null ? null : Component.translatable((String)nature.getDisplayName()).getString();
    }

    @Override
    public String getAbility() {
        String abilityId = this.properties.getAbility();
        AbilityTemplate ability = abilityId == null ? null : Abilities.get((String)abilityId);
        return ability == null ? null : Component.translatable((String)ability.getDisplayName()).getString();
    }

    @Override
    public String getForm() {
        return null;
    }

    @Override
    public String getPokeBall() {
        String pokeBallId = this.properties.getPokeball();
        return pokeBallId == null ? null : this.pokeBallFromId(pokeBallId);
    }

    @Override
    public boolean hasIVs() {
        if (this.ivs == null) {
            return false;
        }
        return this.getHpIV() != null || this.getAtkIV() != null || this.getDefIV() != null || this.getSpAtkIV() != null || this.getSpDefIV() != null || this.getSpeedIV() != null;
    }

    @Override
    public Integer getHpIV() {
        return this.ivs.get((Stat)Stats.HP);
    }

    @Override
    public Integer getAtkIV() {
        return this.ivs.get((Stat)Stats.ATTACK);
    }

    @Override
    public Integer getDefIV() {
        return this.ivs.get((Stat)Stats.DEFENCE);
    }

    @Override
    public Integer getSpAtkIV() {
        return this.ivs.get((Stat)Stats.SPECIAL_ATTACK);
    }

    @Override
    public Integer getSpDefIV() {
        return this.ivs.get((Stat)Stats.SPECIAL_DEFENCE);
    }

    @Override
    public Integer getSpeedIV() {
        return this.ivs.get((Stat)Stats.SPEED);
    }

    public static EnhancedEggLore get(ItemStack itemStack) {
        block7: {
            if (itemStack.getItem() instanceof PokemonEgg) {
                try {
                    if (itemStack.has(PokemonEgg.Companion.getVERSION())) {
                        if (itemStack.has(PokemonEgg.Companion.getPOKEMON_PROPERTIES())) {
                            return new CobbreedingIntegration((String)itemStack.get(PokemonEgg.Companion.getPOKEMON_PROPERTIES()));
                        }
                        if (itemStack.has(PokemonEgg.Companion.getEGG_INFO()) && ModConfig.isEnabled("egg_encryption_warning")) {
                            return new EncryptedEggLore(List.of(LoreEnhancements.translate("egg.cobbreeding_encryption_warning" + (Utils.isSinglePlayer() ? "_singleplayer" : ""), new Object[0]).withStyle(ChatFormatting.RED)));
                        }
                    }
                }
                catch (NoSuchMethodError e) {
                    if (itemStack.has(PokemonEgg.Companion.getEGG_INFO()) && CobbreedingIntegration.isString(itemStack.get(PokemonEgg.Companion.getEGG_INFO()))) {
                        return new CobbreedingIntegration((String)itemStack.get(PokemonEgg.Companion.getEGG_INFO()));
                    }
                    if (!itemStack.has(PokemonEgg.Companion.getPOKEMON_PROPERTIES())) break block7;
                    return new CobbreedingIntegration((String)itemStack.get(PokemonEgg.Companion.getPOKEMON_PROPERTIES()));
                }
            }
        }
        return null;
    }

    private static boolean isString(Object value) {
        return value instanceof String;
    }
}

