/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.PcEnhancements;
import me.justahuman.more_cobblemon_tweaks.utils.Textures;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class IvWidget
implements Renderable {
    protected final PCGUI gui;

    public IvWidget(PCGUI gui) {
        this.gui = gui;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        double x = (double)(this.gui.width - 349) / 2.0;
        double y = (double)(this.gui.height - 205) / 2.0;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.blit(Textures.IV_WIDGET_TEXTURE, (int)(x -= 64.0), (int)(y += 31.0), 64, 128, 0.0f, 0.0f, 64, 128, 64, 128);
        x += 9.5;
        y += 9.5;
        Pokemon pokemon = this.gui.getPreviewPokemon$common();
        if (pokemon != null) {
            IVs ivs = pokemon.getIvs();
            y = this.drawStat(context, ivs, Stats.HP, ChatFormatting.GREEN, x, y, mouseX, mouseY);
            y = this.drawStat(context, ivs, Stats.ATTACK, ChatFormatting.RED, x, y, mouseX, mouseY);
            y = this.drawStat(context, ivs, Stats.DEFENCE, ChatFormatting.GOLD, x, y, mouseX, mouseY);
            y = this.drawStat(context, ivs, Stats.SPECIAL_ATTACK, ChatFormatting.LIGHT_PURPLE, x, y, mouseX, mouseY);
            y = this.drawStat(context, ivs, Stats.SPECIAL_DEFENCE, ChatFormatting.YELLOW, x, y, mouseX, mouseY);
            y = this.drawStat(context, ivs, Stats.SPEED, ChatFormatting.AQUA, x, y, mouseX, mouseY);
            double average = Stats.Companion.getPERMANENT().stream().mapToInt(arg_0 -> ((IVs)ivs).getOrDefault(arg_0)).average().getAsDouble();
            this.drawStat(context, "average", average, ChatFormatting.WHITE, x, y, mouseX, mouseY);
        }
    }

    public double drawStat(GuiGraphics context, IVs ivs, Stats stat, ChatFormatting color, double x, double y, int mouseX, int mouseY) {
        return this.drawStat(context, stat.name().toLowerCase(), Objects.requireNonNullElse(ivs.get((Stat)stat), 0).intValue(), color, x, y, mouseX, mouseY);
    }

    public double drawStat(GuiGraphics context, String stat, double statValue, ChatFormatting color, double x, double y, int mouseX, int mouseY) {
        boolean colored = ModConfig.isEnabled("pc_colored_ivs");
        RenderHelperKt.drawScaledText((GuiGraphics)context, null, (MutableComponent)PcEnhancements.translate("iv_display." + stat, new Object[0]).withStyle(colored ? color : ChatFormatting.WHITE), (Number)x, (Number)y, (float)0.5f, (Number)1, (int)Integer.MAX_VALUE, (int)0xFFFFFF, (boolean)false, (boolean)true, (Integer)mouseX, (Integer)mouseY);
        String value = Screen.hasShiftDown() ? Utils.ivPercent(statValue) : Integer.toString((int)statValue);
        int width = Minecraft.getInstance().font.width(value);
        double valueX = x + 45.0 - (double)((float)width * 0.5f);
        RenderHelperKt.drawScaledText((GuiGraphics)context, null, (MutableComponent)Component.literal((String)value).withStyle(ChatFormatting.WHITE), (Number)valueX, (Number)y, (float)0.5f, (Number)1, (int)Integer.MAX_VALUE, (int)0xFFFFFF, (boolean)false, (boolean)true, (Integer)mouseX, (Integer)mouseY);
        return y + 15.0;
    }
}

