/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.mixins.pc;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.client.gui.pc.BoxStorageSlot;
import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.client.gui.pc.ReleaseConfirmButton;
import com.cobblemon.mod.common.client.gui.pc.StorageWidget;
import com.cobblemon.mod.common.client.gui.summary.widgets.SoundlessWidget;
import com.cobblemon.mod.common.client.storage.ClientPC;
import com.cobblemon.mod.common.net.messages.server.storage.pc.MovePCPokemonPacket;
import com.cobblemon.mod.common.net.messages.server.storage.pc.ReleasePCPokemonPacket;
import com.cobblemon.mod.common.net.messages.server.storage.pc.SwapPCPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import me.justahuman.more_cobblemon_tweaks.MoreCobblemonTweaks;
import me.justahuman.more_cobblemon_tweaks.api.MultiSelector;
import me.justahuman.more_cobblemon_tweaks.api.MultiSelectorState;
import me.justahuman.more_cobblemon_tweaks.features.pc.multiselect.MultiGrabbedStorageSlot;
import me.justahuman.more_cobblemon_tweaks.features.pc.multiselect.SlotPosition;
import me.justahuman.more_cobblemon_tweaks.mixins.accessor.ButtonAccessor;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StorageWidget.class}, remap=false)
public abstract class StorageWidgetMixin
extends SoundlessWidget
implements MultiSelector {
    @Final
    @Shadow
    private PCGUI pcGui;
    @Final
    @Shadow
    private ReleaseConfirmButton releaseYesButton;
    @Unique
    private SlotPosition moreCobblemonTweaks$lastHoveredSlot = SlotPosition.ZERO;
    @Unique
    private PCPosition moreCobblemonTweaks$lastPosition = null;
    @Unique
    private int moreCobblemonTweaks$selectedBox = -1;
    @Unique
    private SlotPosition moreCobblemonTweaks$selectionOrigin = null;
    @Unique
    private final List<Pokemon> moreCobblemonTweaks$selection = new ArrayList<Pokemon>();
    @Unique
    private final Map<UUID, MultiGrabbedStorageSlot> moreCobblemonTweaks$grabbedSlots = new HashMap<UUID, MultiGrabbedStorageSlot>();

    private StorageWidgetMixin(int pX, int pY, int pWidth, int pHeight, @NotNull Component component) {
        super(pX, pY, pWidth, pHeight, component);
    }

    @Inject(method={"<init>(IILcom/cobblemon/mod/common/client/gui/pc/PCGUI;Lcom/cobblemon/mod/common/client/storage/ClientPC;Lcom/cobblemon/mod/common/client/storage/ClientParty;)V"}, at={@At(value="TAIL")})
    private void releaseMultiselect(CallbackInfo ci) {
        Button.OnPress original = ((ButtonAccessor)this.releaseYesButton).getOnPress();
        ((ButtonAccessor)this.releaseYesButton).setOnPress(button -> {
            if (!this.moreCobblemonTweaks$isMultiSelecting()) {
                original.onPress(button);
                return;
            }
            for (Pokemon pokemon : this.moreCobblemonTweaks$selection) {
                PCPosition position = this.pcGui.getPc().getPosition(pokemon);
                if (position == null) continue;
                CobblemonNetwork.sendToServer((NetworkPacket)new ReleasePCPokemonPacket(pokemon.getUuid(), position));
            }
            this.playSound(CobblemonSounds.PC_RELEASE);
            this.resetSelected();
            this.setDisplayConfirmRelease(false);
            this.moreCobblemonTweaks$clearMultiSelection();
        });
    }

    @Inject(at={@At(value="TAIL")}, method={"renderWidget"})
    public void renderGrabbedMultiSelection(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.pose().pushPose();
        context.pose().translate(0.0f, 0.0f, 400.0f);
        for (MultiGrabbedStorageSlot slot : this.moreCobblemonTweaks$grabbedSlots.values()) {
            slot.render(context, mouseX, mouseY, delta);
        }
        context.pose().popPose();
    }

    @Inject(at={@At(value="HEAD")}, method={"onStorageSlotClicked(Lnet/minecraft/client/gui/components/Button;)V"}, cancellable=true)
    public void onSlotClicked(Button button, CallbackInfo ci) {
        boolean selecting;
        if (!button.isHovered()) {
            ci.cancel();
            return;
        }
        if (!this.moreCobblemonTweaks$isMultiSelecting()) {
            return;
        }
        ci.cancel();
        if (!(button instanceof BoxStorageSlot)) {
            return;
        }
        BoxStorageSlot slot = (BoxStorageSlot)button;
        if (slot.getPokemon() == null || Screen.hasControlDown() || slot.getPosition().getBox() != this.moreCobblemonTweaks$selectedBox && this.moreCobblemonTweaks$selectedBox != -1) {
            boolean emptyOnly = slot.getPokemon() == null;
            ClientPC pc = this.pcGui.getPc();
            PCPosition clickedPos = slot.getPosition();
            int box = clickedPos.getBox();
            SlotPosition clicked = SlotPosition.of(clickedPos);
            LinkedHashMap<Pokemon, PCPosition> moves = new LinkedHashMap<Pokemon, PCPosition>();
            for (Pokemon pokemon : this.moreCobblemonTweaks$selection) {
                PCPosition position = pc.getPosition(pokemon);
                if (position == null) continue;
                MultiGrabbedStorageSlot grabbed = this.moreCobblemonTweaks$grabbedSlots.get(pokemon.getUuid());
                SlotPosition offset = grabbed.localSlot.minus(this.moreCobblemonTweaks$selectionOrigin).plus(grabbed.getPlacingOffset(clicked));
                int index = clicked.plus(offset).index();
                PCPosition target = new PCPosition(box, index++);
                while (emptyOnly && pc.get(target) != null && !this.moreCobblemonTweaks$isSelected(target) && index <= 29) {
                    target = new PCPosition(box, index++);
                }
                if (emptyOnly && pc.get(target) != null && !this.moreCobblemonTweaks$isSelected(target)) break;
                moves.put(pokemon, target);
            }
            if (moves.isEmpty()) {
                return;
            }
            CompletionStage<Object> chain = CompletableFuture.completedFuture(null);
            for (Map.Entry entry : moves.entrySet()) {
                Pokemon pokemon = (Pokemon)entry.getKey();
                PCPosition target = (PCPosition)entry.getValue();
                chain = chain.thenComposeAsync($ -> {
                    PCPosition source = pc.getPosition(pokemon);
                    if (source == null) {
                        return CompletableFuture.completedFuture(null);
                    }
                    this.moreCobblemonTweaks$select(source, false);
                    Pokemon targetPokemon = pc.get(target);
                    SwapPCPokemonPacket packet = targetPokemon != null ? new SwapPCPokemonPacket(pokemon.getUuid(), source, targetPokemon.getUuid(), target) : new MovePCPokemonPacket(pokemon.getUuid(), source, target);
                    CompletableFuture packetFuture = new CompletableFuture();
                    Utils.moveAllPokemonFuture = packetFuture;
                    CobblemonNetwork.sendToServer((NetworkPacket)packet);
                    return packetFuture;
                });
            }
            chain.whenComplete(($, t) -> {
                if (t == null) {
                    this.playSound(CobblemonSounds.PC_DROP);
                } else {
                    MoreCobblemonTweaks.LOGGER.error("An error occurred while moving multiple Pok\u00e9mon in the PC.", t);
                }
                Utils.moveAllPokemonFuture = null;
            });
            return;
        }
        PCPosition lastPosition = this.moreCobblemonTweaks$lastPosition;
        PCPosition clickedPosition = slot.getPosition();
        boolean bl = selecting = !this.moreCobblemonTweaks$isSelected(clickedPosition);
        if (lastPosition != null && Screen.hasShiftDown()) {
            int from = Math.min(lastPosition.getSlot(), clickedPosition.getSlot());
            int to = Math.max(lastPosition.getSlot(), clickedPosition.getSlot());
            for (int i = from; i <= to; ++i) {
                PCPosition position = new PCPosition(clickedPosition.getBox(), i);
                this.moreCobblemonTweaks$select(position, selecting);
            }
        } else {
            this.moreCobblemonTweaks$select(clickedPosition, selecting);
            this.moreCobblemonTweaks$lastPosition = clickedPosition;
        }
        this.playSound(selecting ? CobblemonSounds.PC_GRAB : CobblemonSounds.PC_DROP);
    }

    @Unique
    private void moreCobblemonTweaks$select(PCPosition position, boolean select) {
        Pokemon pokemon = this.pcGui.getPc().get(position);
        if (pokemon == null) {
            return;
        }
        if (select) {
            if (this.moreCobblemonTweaks$isSelected(position)) {
                return;
            }
            SlotPosition slot = SlotPosition.of(position);
            SlotPosition localSlot = SlotPosition.of(this.moreCobblemonTweaks$selection.size());
            int boxStartX = this.getX() + 7;
            int boxStartY = this.getY() + 11 + (this.pcGui.getDisplayOptions() ? 5 : 0);
            MultiGrabbedStorageSlot grabbedSlot = new MultiGrabbedStorageSlot(boxStartX + slot.x() * 27, boxStartY + slot.y() * 27, (StorageWidget)this, pokemon, slot, localSlot);
            if (this.moreCobblemonTweaks$selection.isEmpty()) {
                this.moreCobblemonTweaks$selectionOrigin = localSlot;
            }
            this.moreCobblemonTweaks$selectedBox = position.getBox();
            this.moreCobblemonTweaks$selection.add(pokemon);
            this.moreCobblemonTweaks$grabbedSlots.put(pokemon.getUuid(), grabbedSlot);
        } else {
            this.moreCobblemonTweaks$selection.remove(pokemon);
            this.moreCobblemonTweaks$grabbedSlots.remove(pokemon.getUuid());
            if (this.moreCobblemonTweaks$selection.isEmpty()) {
                this.moreCobblemonTweaks$selectedBox = -1;
                this.moreCobblemonTweaks$selectionOrigin = null;
            } else {
                for (int i = 0; i < this.moreCobblemonTweaks$selection.size(); ++i) {
                    Pokemon p = this.moreCobblemonTweaks$selection.get(i);
                    MultiGrabbedStorageSlot slot = this.moreCobblemonTweaks$grabbedSlots.get(p.getUuid());
                    slot.localSlot = SlotPosition.of(i);
                    if (i != 0) continue;
                    this.moreCobblemonTweaks$selectionOrigin = slot.localSlot;
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canDeleteSelected()Z"}, cancellable=true)
    public void canDelete(CallbackInfoReturnable<Boolean> cir) {
        if (this.moreCobblemonTweaks$isMultiSelecting()) {
            cir.setReturnValue((Object)(!this.moreCobblemonTweaks$selection.isEmpty() ? 1 : 0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"mouseClicked"}, cancellable=true, remap=true)
    public void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (!this.visible) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean moreCobblemonTweaks$isMultiSelecting() {
        return ((MultiSelectorState)this.pcGui).moreCobblemonTweaks$isMultiSelecting();
    }

    @Override
    public boolean moreCobblemonTweaks$isSelected(PCPosition position) {
        Pokemon pokemon = this.pcGui.getPc().get(position);
        return pokemon != null && this.moreCobblemonTweaks$selection.contains(pokemon);
    }

    @Override
    public SlotPosition moreCobblemonTweaks$getSelectionOrigin() {
        return this.moreCobblemonTweaks$selectionOrigin;
    }

    @Override
    public SlotPosition moreCobblemonTweaks$getHoveredSlot(int mouseX, int mouseY) {
        for (GuiEventListener child : this.getChildren()) {
            BoxStorageSlot boxSlot;
            if (!(child instanceof BoxStorageSlot) || !(boxSlot = (BoxStorageSlot)child).isHovered(mouseX, mouseY)) continue;
            this.moreCobblemonTweaks$lastHoveredSlot = SlotPosition.of(boxSlot.getPosition());
            return this.moreCobblemonTweaks$lastHoveredSlot;
        }
        return this.moreCobblemonTweaks$lastHoveredSlot;
    }

    @Override
    public List<Pokemon> moreCobblemonTweaks$getSelectedPokemon() {
        return this.moreCobblemonTweaks$selection;
    }

    @Override
    public void moreCobblemonTweaks$clearMultiSelection() {
        this.moreCobblemonTweaks$selectedBox = -1;
        this.moreCobblemonTweaks$selection.clear();
        this.moreCobblemonTweaks$grabbedSlots.clear();
        this.moreCobblemonTweaks$lastPosition = null;
    }

    @Shadow
    public abstract void setDisplayConfirmRelease(boolean var1);

    @Shadow
    protected abstract void playSound(SoundEvent var1);

    @Shadow
    public abstract void setupStorageSlots();

    @Shadow
    public abstract void resetSelected();
}

