/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record MobSkullShaderData(ItemStackHolder stackHolder, ResourceLocation shaderId) {
    public static final Codec<MobSkullShaderData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStackHolder.CODEC.fieldOf("item").forGetter(MobSkullShaderData::stackHolder), (App)ResourceLocation.CODEC.fieldOf("shader").forGetter(MobSkullShaderData::shaderId)).apply((Applicative)instance, (item, shaderId) -> new MobSkullShaderData((ItemStackHolder)item, shaderId.withPath("shaders/post/" + shaderId.getPath() + ".json"))));

    public record ItemStackHolder(Item item, DataComponentMap components) {
        public static final Codec<ItemStackHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("id").forGetter(ItemStackHolder::item), (App)DataComponentMap.CODEC.optionalFieldOf("components", (Object)DataComponentMap.EMPTY).forGetter(ItemStackHolder::components)).apply((Applicative)instance, ItemStackHolder::new));

        public boolean matches(ItemStack stack) {
            if (stack.is(this.item)) {
                for (TypedDataComponent component : this.components) {
                    DataComponentType type = component.type();
                    if (stack.has(type) && component.value().equals(stack.get(type))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

