/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.item;

import einstein.subtle_effects.init.ModConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ParticleUtils;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BoneMealItem.class})
public class BoneMealItemMixin {
    @Inject(method={"addGrowthParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/ParticleUtils;spawnParticles(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;IDDZLnet/minecraft/core/particles/ParticleOptions;)V")})
    private static void spawnParticles(LevelAccessor accessor, BlockPos pos, int data, CallbackInfo ci) {
        if (ModConfigs.ITEMS.boneMealUsingParticles) {
            BlockPos blockPos;
            Block block = accessor.getBlockState(pos).getBlock();
            if (block instanceof BonemealableBlock) {
                BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
                blockPos = bonemealableBlock.getParticlePos(pos);
            } else {
                blockPos = pos;
            }
            BlockPos particlePos = blockPos;
            ParticleUtils.spawnParticles((LevelAccessor)accessor, (BlockPos)particlePos, (int)data, (double)3.0, (double)1.0, (boolean)false, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.BONE_MEAL)));
        }
    }

    @Inject(method={"addGrowthParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/ParticleUtils;spawnParticleInBlock(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;ILnet/minecraft/core/particles/ParticleOptions;)V")})
    private static void spawnParticlesInBlock(LevelAccessor accessor, BlockPos pos, int data, CallbackInfo ci) {
        if (ModConfigs.ITEMS.boneMealUsingParticles) {
            BlockPos particlePos = ((BonemealableBlock)accessor.getBlockState(pos).getBlock()).getParticlePos(pos);
            ParticleUtils.spawnParticleInBlock((LevelAccessor)accessor, (BlockPos)particlePos, (int)(data / 3), (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.BONE_MEAL)));
        }
    }
}

