/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.PositionParticleOptions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BeaconParticle
extends SparkParticle {
    private final BlockPos beaconPos;
    private final List<BeaconBlockEntity.BeaconBeamSection> beamSections = new ArrayList<BeaconBlockEntity.BeaconBeamSection>();

    protected BeaconParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, BlockPos beaconPos) {
        super(level, x, y, z, 0.0, 0.0, 0.0, 0.0f, sprites);
        this.beaconPos = beaconPos;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.gravity = -0.1f * ((Float)ModConfigs.BLOCKS.beaconParticlesSpeed.get()).floatValue();
        this.lifetime = 1;
        this.hasPhysics = false;
        this.speedUpWhenYMotionIsBlocked = false;
    }

    public void tick() {
        super.tick();
        if (this.age % 20 == 0) {
            boolean hasMultipleSections;
            BlockEntity blockEntity = this.level.getBlockEntity(this.beaconPos);
            if (!(blockEntity instanceof BeaconBlockEntity)) {
                this.remove();
                return;
            }
            BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
            List sections = beaconBlockEntity.getBeamSections();
            boolean isNotColored = ModConfigs.BLOCKS.beaconParticlesDisplayType == ModBlockConfigs.BeaconParticlesDisplayType.NOT_COLORED;
            boolean bl = hasMultipleSections = sections.size() > 1;
            if (sections.isEmpty() || hasMultipleSections && isNotColored) {
                this.remove();
                return;
            }
            boolean hadMultipleSections = this.beamSections.size() > 1;
            this.beamSections.clear();
            if (!isNotColored && hasMultipleSections || hadMultipleSections) {
                this.beamSections.addAll(sections);
            }
        }
        if (this.y >= (double)Mth.floor((double)this.y) && !this.beamSections.isEmpty()) {
            BeaconBlockEntity.BeaconBeamSection beamSection = null;
            int lastHeight = this.beaconPos.getY() - 1;
            for (BeaconBlockEntity.BeaconBeamSection section : this.beamSections) {
                if (!(this.y >= (double)(lastHeight += section.getHeight()))) continue;
                beamSection = section;
            }
            if (beamSection != null) {
                int color = beamSection.getColor();
                this.rCol = (float)(color >> 16 & 0xFF) / 255.0f;
                this.gCol = (float)(color >> 8 & 0xFF) / 255.0f;
                this.bCol = (float)(color & 0xFF) / 255.0f;
            }
        }
        if (this.y == this.yo || this.y >= (double)this.level.getMaxBuildHeight()) {
            this.remove();
            return;
        }
        ++this.lifetime;
    }

    @Override
    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + partialTicks) / 20.0f * 32.0f), (float)0.0f, (float)1.0f);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<PositionParticleOptions>
    {
        public Particle createParticle(PositionParticleOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BeaconParticle(level, x, y, z, this.sprites, type.pos());
        }
    }
}

