/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModParticleRenderTypes;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;

public class SlimeTrailParticle
extends FlatPlaneParticle {
    private final BlockPos pos;

    protected SlimeTrailParticle(ClientLevel level, SpriteSet sprites, double x, double y, double z, float scale) {
        super(level, x, y, z);
        this.pickSprite(sprites);
        this.quadSize = 0.5f * scale;
        this.setSize(this.quadSize + 1.0f, 0.1f);
        this.lifetime = (int)Math.min(300.0f + 200.0f * scale, 1200.0f);
        this.rotation.rotateY((float)(90 * this.random.nextInt(3)) * ((float)Math.PI / 180)).rotateX(-1.5707964f);
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.renderBackFace = true;
    }

    public ParticleRenderType getRenderType() {
        return ModParticleRenderTypes.getBlendedOrTransparent();
    }

    public void tick() {
        if (!this.level.getBlockState(this.pos).isAir() || this.level.getBlockState(this.pos.below()).isAir()) {
            this.remove();
            return;
        }
        if (this.age >= this.lifetime / 2) {
            this.alpha = Mth.clamp((float)(this.alpha - 0.015f), (float)0.0f, (float)1.0f);
            if (this.alpha == 0.0f) {
                this.remove();
            }
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SlimeTrailParticle(level, this.sprites, x, y, z, Math.min(options.f(), 64.0f));
        }
    }
}

