/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking;

import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.SereneSeasonsCompat;
import einstein.subtle_effects.configs.environment.FireflyConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.util.MathUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class FireflyManager {
    public static void tick(Level level, BlockPos pos, BlockState state, RandomSource random) {
        if (!ModConfigs.ENVIRONMENT.fireflies.firefliesEnabled) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null || minecraft.player.tickCount < 200) {
            return;
        }
        Optional dimensionKey = level.dimensionTypeRegistration().unwrapKey();
        if (dimensionKey.isEmpty() || ModConfigs.ENVIRONMENT.fireflies.dimensionBlocklist.contains((Object)((ResourceKey)dimensionKey.get()).location())) {
            return;
        }
        if (CompatHelper.IS_SERENE_SEANSONS_LOADED.get().booleanValue() && SereneSeasonsCompat.isColdSeason(level, ModConfigs.ENVIRONMENT.fireflies.ignoredSeasons)) {
            return;
        }
        Holder biome = level.getBiome(pos);
        Optional biomeKey = biome.unwrapKey();
        if (biomeKey.isEmpty()) {
            return;
        }
        ResourceLocation biomeId = ((ResourceKey)biomeKey.get()).location();
        if (!ModConfigs.ENVIRONMENT.fireflies.biomesBlocklist.contains((Object)biomeId)) {
            float time;
            boolean isHabitatBiome = ModConfigs.ENVIRONMENT.fireflies.habitatBiomes.contains((Object)biomeId);
            boolean isSpawnable = ModConfigs.ENVIRONMENT.fireflies.spawnableBlocks.contains((Object)state.getBlock());
            if (!(isHabitatBiome || !ModConfigs.ENVIRONMENT.fireflies.onlyAllowInHabitatBiomes && isSpawnable)) {
                return;
            }
            boolean canSeeSky = level.canSeeSky(pos);
            int surfaceLevel = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY();
            if (isHabitatBiome) {
                if (!canSeeSky && !isSpawnable) {
                    return;
                }
                if (canSeeSky && surfaceLevel + 10 < pos.getY()) {
                    return;
                }
            }
            if (!(!((Biome)biome.value()).warmEnoughToRain(pos) && !ModConfigs.ENVIRONMENT.fireflies.biomesAllowlist.contains((Object)biomeId) || !((time = (float)level.getDayTime() % 24000.0f) > 13000.0f && time < 23000.0f) && level.getBrightness(LightLayer.SKY, pos) != 0 || level.getBrightness(LightLayer.BLOCK, pos) > 5 || level.isRaining() && canSeeSky && surfaceLevel <= pos.getY() || state.isCollisionShapeFullBlock((BlockGetter)level, pos) || !level.getFluidState(pos).isEmpty())) {
                if (FireflyManager.canSpawn(random, isHabitatBiome)) {
                    level.addParticle((ParticleOptions)ModConfigs.ENVIRONMENT.fireflies.fireflyType.getParticle().get(), (double)pos.getX() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), (double)pos.getY() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), (double)pos.getZ() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.4375), 0.0, 0.0, 0.0);
                }
                if (((Float)ModConfigs.ENVIRONMENT.fireflies.fireflySoundVolume.get()).floatValue() > 0.0f && FireflyManager.canPlaySound(random, isHabitatBiome)) {
                    level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSounds.FIREFLY_BUZZ.get(), SoundSource.AMBIENT, ((Float)ModConfigs.ENVIRONMENT.fireflies.fireflySoundVolume.get()).floatValue(), 1.0f, false);
                }
            }
        }
    }

    private static boolean canPlaySound(RandomSource random, boolean isHabitatBiome) {
        if (isHabitatBiome) {
            return random.nextDouble() < 1.0E-5 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.habitatBiomeDensity.get()).intValue();
        }
        return random.nextDouble() < 3.0E-4 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.defaultDensity.get()).intValue();
    }

    private static boolean canSpawn(RandomSource random, boolean isHabitatBiome) {
        if (isHabitatBiome) {
            return random.nextDouble() < 5.0E-4 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.habitatBiomeDensity.get()).intValue();
        }
        int spawnRate = ModConfigs.ENVIRONMENT.fireflies.fireflyType == FireflyConfigs.FireflyType.VANILLA ? 170 : 1;
        return random.nextDouble() < 0.008 * (double)((Integer)ModConfigs.ENVIRONMENT.fireflies.defaultDensity.get()).intValue() * (double)spawnRate;
    }
}

