/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.data.providers.group;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.data.providers.BaseDataProvider;
import io.wispforest.accessories.api.data.providers.group.RawSlotGroup;
import io.wispforest.accessories.api.data.providers.group.SlotGroupBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class GroupDataProvider
extends BaseDataProvider<GroupOutput> {
    private final Codec<RawSlotGroup> CODEC = CodecUtils.toCodec(RawSlotGroup.ENDEC);

    public GroupDataProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
        super(packOutput, completableFuture);
    }

    @Override
    protected abstract void buildData(HolderLookup.Provider var1, GroupOutput var2);

    public SlotGroupBuilder builder(ResourceLocation uniqueLocation) {
        return this.builder(uniqueLocation.toString());
    }

    public SlotGroupBuilder builder(String groupName) {
        return new SlotGroupBuilder(groupName, false);
    }

    @Override
    public final String getName() {
        return "SlotGroup";
    }

    @Override
    protected final String type() {
        return "accessories/group";
    }

    @Override
    protected final PackOutput.Target target() {
        return PackOutput.Target.DATA_PACK;
    }

    @Override
    protected final GroupOutput buildOutput(final CachedOutput cachedOutput, final HolderLookup.Provider provider) {
        return new GroupOutput(){
            final Set<ResourceLocation> set = Sets.newHashSet();
            final List<CompletableFuture<?>> list = new ArrayList();

            @Override
            public void accept(String namespace, RawSlotGroup rawSlotType) {
                ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)rawSlotType.name().replace(":", "/"));
                if (!this.set.add(location)) {
                    throw new IllegalStateException("Duplicate Group: " + String.valueOf(location));
                }
                this.list.add(DataProvider.saveStable((CachedOutput)cachedOutput, (HolderLookup.Provider)provider, GroupDataProvider.this.CODEC, (Object)rawSlotType, (Path)GroupDataProvider.this.pathProvider().json(location)));
            }

            @Override
            public Collection<CompletableFuture<?>> futures() {
                return this.list;
            }
        };
    }

    public static interface GroupOutput
    extends BaseDataProvider.DataOutput {
        public void accept(String var1, RawSlotGroup var2);
    }
}

