/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.caching;

import com.google.common.cache.Cache;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.EquipmentChecking;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.impl.caching.EquipmentLookupCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccessoriesContainerLookupCache
extends EquipmentLookupCache {
    private final AccessoriesContainer container;
    private boolean isEmpty = true;

    public AccessoriesContainerLookupCache(AccessoriesContainer container) {
        this.container = container;
    }

    @Override
    public boolean isEquipped(ItemStackBasedPredicate predicate) {
        Boolean value;
        if (this.isEmpty) {
            this.isEmpty = false;
        }
        if ((value = (Boolean)this.isEquipped.getIfPresent((Object)predicate)) == null) {
            value = this.getAllEquipped().stream().anyMatch(slotEntryReference -> predicate.test(slotEntryReference.stack()));
            this.isEquipped.put((Object)predicate, (Object)value);
        }
        return value;
    }

    @Override
    @Nullable
    public SlotEntryReference firstEquipped(ItemStackBasedPredicate predicate, EquipmentChecking check) {
        Cache cache;
        Optional<Object> value;
        if (this.isEmpty) {
            this.isEmpty = false;
        }
        if ((value = (Optional<Object>)(cache = check == EquipmentChecking.ACCESSORIES_ONLY ? this.firstEquipped_ACCESSORIES_ONLY : this.firstEquipped_COSMETICALLY_OVERRIDABLE).getIfPresent((Object)predicate)) == null) {
            for (Pair<Integer, ItemStack> stackEntry : this.container.getAccessories()) {
                SlotEntryReference entryReference;
                ItemStack cosmetic;
                ItemStack stack = (ItemStack)stackEntry.getSecond();
                SlotReference reference = this.container.createReference((Integer)stackEntry.getFirst());
                if (check == EquipmentChecking.COSMETICALLY_OVERRIDABLE && !(cosmetic = this.container.getCosmeticAccessories().getItem(reference.slot())).isEmpty() && Accessories.config().clientOptions.showCosmeticAccessories()) {
                    stack = cosmetic;
                }
                if ((entryReference = AccessoryNestUtils.recursiveStackHandling(stack, reference, (innerStack, ref) -> !innerStack.isEmpty() && predicate.test((ItemStack)innerStack) ? new SlotEntryReference(reference, (ItemStack)innerStack) : null)) == null) continue;
                value = Optional.of(entryReference);
                break;
            }
            if (value == null) {
                value = Optional.empty();
            }
            cache.put((Object)predicate, value);
        }
        return value.orElse(null);
    }

    @Override
    @Nullable
    public List<SlotEntryReference> getEquipped(ItemStackBasedPredicate predicate) {
        List<SlotEntryReference> value;
        if (this.isEmpty) {
            this.isEmpty = false;
        }
        if ((value = (List<SlotEntryReference>)this.equipped.getIfPresent((Object)predicate)) == null) {
            value = this.getAllEquipped().stream().filter(slotEntryReference -> predicate.test(slotEntryReference.stack())).toList();
            this.equipped.put((Object)predicate, value);
        }
        return value;
    }

    @Override
    public List<SlotEntryReference> getAllEquipped() {
        if (this.isEmpty) {
            this.isEmpty = false;
        }
        if (this.getAllEquipped != null) {
            return this.getAllEquipped;
        }
        ArrayList<SlotEntryReference> currentlyAllEquipped = new ArrayList<SlotEntryReference>();
        for (Pair<Integer, ItemStack> stackEntry : this.container.getAccessories()) {
            ItemStack stack = (ItemStack)stackEntry.getSecond();
            if (stack.isEmpty()) continue;
            SlotReference reference = this.container.createReference((Integer)stackEntry.getFirst());
            AccessoryNestUtils.recursiveStackConsumption(stack, reference, (innerStack, ref) -> currentlyAllEquipped.add(new SlotEntryReference((SlotReference)ref, (ItemStack)innerStack)));
        }
        this.getAllEquipped = currentlyAllEquipped;
        return currentlyAllEquipped;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.isEmpty = true;
    }
}

