/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin.temp_fixes;

import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NbtUtils.class})
public abstract class NbtUtilsMixin {
    @Inject(method={"loadUUID(Lnet/minecraft/nbt/Tag;)Ljava/util/UUID;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void adjustLoadToAllowListVariant(Tag tag, CallbackInfoReturnable<UUID> cir) {
        ListTag listTag;
        if (tag instanceof ListTag && (listTag = (ListTag)tag).getElementType() == 3) {
            if (listTag.size() != 4) {
                throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + listTag.size() + ".");
            }
            int[] array = new int[listTag.size()];
            for (int i = 0; i < listTag.size(); ++i) {
                Tag tagEntry = listTag.get(i);
                array[i] = ((NumericTag)tagEntry).getAsInt();
            }
            cir.setReturnValue((Object)UUIDUtil.uuidFromIntArray((int[])array));
        }
    }
}

