/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIFont;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public interface StringImpl {
    public Component component();

    public FormattedCharSequence characters();

    default public CGRect boundingRectWithFont(UIFont font) {
        float width = font._getTextWidth(this.characters());
        return new CGRect(0.0f, 0.0f, width, font.lineHeight());
    }

    default public List<NSString> split(UIFont font, float maxWidth) {
        Component contents = this.component();
        if (contents != null) {
            return font._splitLines(contents, maxWidth, false, NSString::new);
        }
        return new ArrayList<NSString>();
    }

    default public Map<String, ?> attributes(int width, UIFont font) {
        Style style = font._getStyleByWidth(this.characters(), width);
        if (style == null) {
            return null;
        }
        HashMap<String, ClickEvent> attributes = new HashMap<String, ClickEvent>();
        attributes.put("ClickEvent", style.getClickEvent());
        return attributes;
    }

    public static NSString join(Iterable<? extends NSString> strings, String separator) {
        int index = 0;
        NSMutableString result = new NSMutableString("");
        for (NSString nSString : strings) {
            if (index++ > 0) {
                result.append(separator);
            }
            result.append(nSString);
        }
        return result;
    }

    public static NSString localizedString(String table, String key, Object ... args) {
        String fullKey = String.format("%s.%s.%s", table, "armourers_workshop", key);
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof NSString)) continue;
            NSString text = (NSString)object;
            args[i] = text.component();
        }
        return new NSString((Component)TranslateUtils.title(fullKey, args));
    }
}

