/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.foundation.NSString;
import com.apple.library.impl.InputKeyImpl;
import com.apple.library.impl.InputManagerImpl;
import com.apple.library.impl.StringImpl;
import com.apple.library.uikit.UIEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.client.Minecraft;

public class UIMenuItem {
    private static final Map<String, Predicate<UIEvent>> TESTER = Collections.immutableMap(it -> {
        it.put((Object)"key.keyboard.control", event -> InputManagerImpl.hasControlDown());
        it.put((Object)"key.keyboard.shift", event -> InputManagerImpl.hasShiftDown());
        it.put((Object)"key.keyboard.alt", event -> InputManagerImpl.hasAltDown());
    });
    private static final Map<String, Supplier<String>> TESTER_NAME = Collections.immutableMap(it -> {
        it.put((Object)"key.keyboard.alt", () -> "ALT");
        it.put((Object)"key.keyboard.shift", () -> "SHIFT");
        it.put((Object)"key.keyboard.control", () -> {
            if (Minecraft.ON_OSX) {
                return "CMD";
            }
            return "CTRL";
        });
    });
    private final NSString title;
    private final NSString key;
    private final Collection<Runnable> actions;
    private final Collection<Predicate<UIEvent>> conditions;
    private final int group;
    private final boolean isEnabled;

    private UIMenuItem(NSString title, NSString key, Collection<Runnable> actions, Collection<Predicate<UIEvent>> conditions, int group, boolean isEnabled) {
        this.title = title;
        this.key = key;
        this.actions = actions;
        this.conditions = conditions;
        this.group = group;
        this.isEnabled = isEnabled;
    }

    public static Builder of(String title) {
        return new Builder(new NSString(title));
    }

    public static Builder of(NSString title) {
        return new Builder(title);
    }

    public void perform(UIEvent event) {
        this.actions.forEach(Runnable::run);
    }

    public boolean test(UIEvent event) {
        return this.conditions.stream().allMatch(it -> it.test(event));
    }

    public NSString title() {
        return this.title;
    }

    public NSString key() {
        return this.key;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public int group() {
        return this.group;
    }

    public static class Builder {
        private int group;
        private boolean isEnabled = true;
        private NSString inputName;
        private final NSString title;
        private final ArrayList<Runnable> actions = new ArrayList();
        private final ArrayList<Predicate<UIEvent>> conditions = new ArrayList();

        public Builder(NSString title) {
            this.title = title;
        }

        public Builder keyUp(String ... keyNames) {
            return this.addCondition(UIEvent.Type.KEY_UP, keyNames);
        }

        public Builder keyDown(String ... keyNames) {
            return this.addCondition(UIEvent.Type.KEY_DOWN, keyNames);
        }

        public Builder execute(Runnable handler) {
            this.actions.add(handler);
            return this;
        }

        public Builder group(int group) {
            this.group = group;
            return this;
        }

        public Builder enable(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public UIMenuItem build() {
            return new UIMenuItem(this.title, this.inputName, this.actions, this.conditions, this.group, this.isEnabled);
        }

        private Builder addCondition(UIEvent.Type eventType, String ... keyNames) {
            this.conditions.add(event -> event.type() == eventType);
            ArrayList<NSString> names = new ArrayList<NSString>();
            for (String keyName : keyNames) {
                Predicate<UIEvent> condition = TESTER.get(keyName);
                if (condition != null) {
                    this.conditions.add(condition);
                    Supplier<String> name = TESTER_NAME.get(keyName);
                    if (name == null) continue;
                    names.add(new NSString(name.get()));
                    continue;
                }
                InputKeyImpl key = InputKeyImpl.get(keyName);
                this.conditions.add(event -> key.test(event.key(), event.keyModifier()));
                names.add(new NSString(key.name()));
            }
            this.inputName = StringImpl.join(names, " + ");
            return this;
        }
    }
}

