/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.List;

public class UIStackView
extends UIView {
    protected Axis _axis = Axis.HORIZONTAL;
    protected Distribution _distribution = Distribution.FILL;
    protected Alignment _alignment = Alignment.FILL;
    protected float _spacing = 0.0f;
    protected final ArrayList<UIView> _arrangedSubviews = new ArrayList();

    public UIStackView(CGRect frame) {
        super(frame);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        this._apply(this._arrangedSubviews);
    }

    public void addArrangedSubview(UIView view) {
        this.addSubview(view);
        this._arrangedSubviews.add(view);
        this.setNeedsLayout();
    }

    public void removeArrangedSubview(UIView view) {
        view.removeFromSuperview();
        this._arrangedSubviews.remove(view);
        this.setNeedsLayout();
    }

    public void insertArrangedSubviewAtIndex(UIView view, int stackIndex) {
        this.insertViewAtIndex(view, stackIndex);
        this._arrangedSubviews.add(stackIndex, view);
        this.setNeedsLayout();
    }

    public final List<UIView> arrangedSubviews() {
        return this._arrangedSubviews;
    }

    public void setDistribution(Distribution distribution) {
        this._distribution = distribution;
    }

    public Distribution distribution() {
        return this._distribution;
    }

    public void setAlignment(Alignment alignment) {
        this._alignment = alignment;
    }

    public Alignment alignment() {
        return this._alignment;
    }

    public void setAxis(Axis axis) {
        this._axis = axis;
    }

    public Axis axis() {
        return this._axis;
    }

    public void setSpacing(float spacing) {
        this._spacing = spacing;
    }

    public float spacing() {
        return this._spacing;
    }

    public void setCustomSpacing(float spacing, UIView arrangedSubview) {
    }

    public float customSpacing(UIView arrangedSubview) {
        return 0.0f;
    }

    private void _apply(List<UIView> views) {
        CGRect bounds = this._rotation(this.bounds().copy());
        ArrayList<CGRect> rects = new ArrayList<CGRect>();
        for (UIView view : views) {
            rects.add(this._rotation(view.frame().copy()));
        }
        this._applySize(bounds, rects, this._distribution);
        this._applyOffset(bounds, rects, this._alignment);
        for (int i = 0; i < rects.size(); ++i) {
            views.get(i).setFrame(this._rotation(rects.get(i)));
        }
    }

    private void _applySize(CGRect bounds, List<CGRect> rects, Distribution distribution) {
        int count = rects.size();
        if (count == 0) {
            return;
        }
        switch (distribution.ordinal()) {
            case 0: {
                this._applySize(bounds, rects, Distribution.FILL_EQUALLY);
                break;
            }
            case 1: {
                float usableSize = bounds.width() - this._spacing * (float)(count - 1);
                float itemLeft = 0.0f;
                float itemWidth = usableSize / (float)count;
                for (CGRect rect : rects) {
                    rect.setX(itemLeft);
                    rect.setWidth(itemWidth);
                    itemLeft += itemWidth + this._spacing;
                }
                break;
            }
            case 2: {
                float usableSize = bounds.width() - this._spacing * (float)(count - 1);
                CGSize resolvedSize = this._calcSize(rects);
                float contentWidth = Math.max(resolvedSize.width, 1.0f);
                float itemLeft = 0.0f;
                for (CGRect rect : rects) {
                    float pro = rect.width / contentWidth;
                    float itemWidth = pro * usableSize;
                    rect.setX(itemLeft);
                    rect.setWidth(itemWidth);
                    itemLeft += itemWidth + this._spacing;
                }
                break;
            }
            case 3: {
                if (count == 1) {
                    this._applySize(bounds, rects, Distribution.FILL_EQUALLY);
                    break;
                }
                CGSize resolvedSize = this._calcSize(rects);
                float contentSize = Math.max(resolvedSize.width, 1.0f);
                float spacing = (bounds.width - contentSize) / (float)(count - 1);
                float itemLeft = 0.0f;
                for (CGRect rect : rects) {
                    float itemWidth = rect.width;
                    rect.setX(itemLeft);
                    itemLeft += itemWidth + spacing;
                }
                break;
            }
            case 4: {
                float centerSize = bounds.width() / (float)(count + 1);
                float itemLeft = 0.0f;
                for (CGRect rect : rects) {
                    float itemWidth = rect.width();
                    rect.setX(itemLeft + centerSize - itemWidth / 2.0f);
                    itemLeft += centerSize;
                }
                break;
            }
        }
    }

    private void _applyOffset(CGRect bounds, List<CGRect> rects, Alignment alignment) {
        int count = rects.size();
        if (count == 0) {
            return;
        }
        switch (alignment.ordinal()) {
            case 0: {
                float usableHeight = bounds.height();
                for (CGRect rect : rects) {
                    rect.setY(0.0f);
                    rect.setHeight(usableHeight);
                }
                break;
            }
            case 1: 
            case 2: {
                for (CGRect rect : rects) {
                    rect.setY(0.0f);
                }
                break;
            }
            case 5: 
            case 6: {
                float usableHeight = bounds.height();
                for (CGRect rect : rects) {
                    rect.setY(usableHeight - rect.height());
                }
                break;
            }
            case 4: {
                float usableHeight = bounds.height();
                for (CGRect rect : rects) {
                    rect.setY((usableHeight - rect.height()) / 2.0f);
                }
                break;
            }
        }
    }

    private CGSize _calcSize(List<CGRect> rects) {
        float width = 0.0f;
        float height = 0.0f;
        for (CGRect rect : rects) {
            width += rect.width();
            height = Math.max(height, rect.height());
        }
        return new CGSize(width, height);
    }

    private CGRect _rotation(CGRect rect) {
        if (this._axis == Axis.VERTICAL) {
            float x = rect.y();
            float y = rect.x();
            float width = rect.height();
            float height = rect.width();
            rect.setX(x);
            rect.setY(y);
            rect.setWidth(width);
            rect.setHeight(height);
        }
        return rect;
    }

    public static enum Axis {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum Distribution {
        FILL,
        FILL_EQUALLY,
        FILL_PROPORTIONALLY,
        EQUAL_SPACING,
        EQUAL_CENTERING;

    }

    public static enum Alignment {
        FILL,
        LEADING,
        TOP,
        FIRST_BASELINE,
        CENTER,
        TRAILING,
        BOTTOM,
        LAST_BASELINE;

    }
}

