/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.guide;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.AbstractGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideDataProvider;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideRendererManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.OpenModelPart;
import moe.plushie.armourers_workshop.core.utils.OpenModelPartBuilder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FeetGuideRenderer
extends AbstractGuideRenderer {
    protected final OpenModelPart legLeft = OpenModelPartBuilder.player().uv(16, 48).cube(-2.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f).build();
    protected final OpenModelPart legRight = OpenModelPartBuilder.player().uv(0, 16).cube(-2.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f).build();
    protected final OpenModelPart leftPants = OpenModelPartBuilder.player().uv(0, 48).cube(-2.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.25f).build();
    protected final OpenModelPart rightPants = OpenModelPartBuilder.player().uv(0, 32).cube(-2.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0.25f).build();

    @Override
    public void init(GuideRendererManager rendererManager) {
        rendererManager.register(SkinPartTypes.BIPPED_SKIRT, this::render);
        rendererManager.register(SkinPartTypes.BIPPED_LEFT_THIGH, this::renderLeftLeg);
        rendererManager.register(SkinPartTypes.BIPPED_RIGHT_THIGH, this::renderRightLeg);
        rendererManager.register(SkinPartTypes.BIPPED_LEFT_FOOT, this::renderLeftLeg);
        rendererManager.register(SkinPartTypes.BIPPED_RIGHT_FOOT, this::renderRightLeg);
    }

    public void render(IPoseStack poseStack, GuideDataProvider provider, int light, int overlay, IBufferSource bufferSource) {
        float f = 0.0625f;
        poseStack.pushPose();
        poseStack.translate(2.0f * f, 0.0f, 0.0f);
        this.renderLeftLeg(poseStack, provider, light, overlay, bufferSource);
        poseStack.translate(-4.0f * f, 0.0f, 0.0f);
        this.renderRightLeg(poseStack, provider, light, overlay, bufferSource);
        poseStack.popPose();
    }

    public void renderLeftLeg(IPoseStack poseStack, GuideDataProvider provider, int light, int overlay, IBufferSource bufferSource) {
        this.legLeft.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT), light, overlay);
        if (provider.shouldRenderOverlay(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS)) {
            this.leftPants.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT_NO_CULL), light, overlay);
        }
    }

    public void renderRightLeg(IPoseStack poseStack, GuideDataProvider provider, int light, int overlay, IBufferSource bufferSource) {
        this.legRight.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT), light, overlay);
        if (provider.shouldRenderOverlay(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS)) {
            this.rightPants.render(poseStack, bufferSource.getBuffer(SkinRenderType.PLAYER_CUTOUT_NO_CULL), light, overlay);
        }
    }
}

