/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.panel;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.panel.ArmourerBaseSkinPanel;
import moe.plushie.armourers_workshop.core.client.gui.widget.InventoryBox;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerBlockSkinPanel
extends ArmourerBaseSkinPanel {
    protected UICheckBox blockBed;
    protected UICheckBox blockEnderInventory;
    protected UICheckBox blockInventory;
    protected UILabel inventoryTitle;
    protected UILabel inventorySlot;
    protected InventoryBox inventoryBox;

    public ArmourerBlockSkinPanel(SkinProperties skinProperties) {
        super(skinProperties);
    }

    @Override
    public void apply() {
        this.resolveConflicts();
        this.resolveSlots();
        super.apply();
    }

    public void applySlot(UIControl sender) {
        CGPoint offset = this.inventoryBox.offset();
        int width = (int)(offset.x / 10.0f) + 1;
        int height = (int)(offset.y / 10.0f) + 1;
        this.skinProperties.put(SkinProperty.BLOCK_INVENTORY_WIDTH, width);
        this.skinProperties.put(SkinProperty.BLOCK_INVENTORY_HEIGHT, height);
        this.apply();
    }

    @Override
    public void init() {
        super.init();
        this.addCheckBox(0, 0, SkinProperty.BLOCK_GLOWING);
        this.addCheckBox(0, 0, SkinProperty.BLOCK_LADDER);
        this.addCheckBox(0, 0, SkinProperty.BLOCK_NO_COLLISION);
        this.addCheckBox(0, 0, SkinProperty.BLOCK_SEAT);
        this.addCheckBox(0, 0, SkinProperty.BLOCK_MULTIBLOCK);
        this.blockBed = this.addCheckBox(12, 0, SkinProperty.BLOCK_BED);
        this.blockEnderInventory = this.addCheckBox(0, 0, SkinProperty.BLOCK_ENDER_INVENTORY);
        this.blockInventory = this.addCheckBox(0, 0, SkinProperty.BLOCK_INVENTORY);
        this.inventoryTitle = this.addLabel(0, -2, this.getDisplayText("label.inventorySize", new Object[0]));
        this.inventorySlot = this.addLabel(0, -1, new NSString(""));
        this.inventoryBox = this.addInventoryBox(0, -2);
        this.resolveConflicts();
        this.resolveSlots();
    }

    protected InventoryBox addInventoryBox(int x, int y) {
        InventoryBox box = new InventoryBox(new CGRect(this.cursorX + (float)x, this.cursorY + (float)y, 90.0f, 60.0f));
        box.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerBlockSkinPanel::applySlot);
        this.addSubview(box);
        return box;
    }

    private void resolveSlots() {
        if (this.inventorySlot == null) {
            return;
        }
        boolean isEnabled = this.blockInventory.isEnabled() && this.blockInventory.isSelected();
        Integer width = this.skinProperties.get(SkinProperty.BLOCK_INVENTORY_WIDTH);
        Integer height = this.skinProperties.get(SkinProperty.BLOCK_INVENTORY_HEIGHT);
        this.inventorySlot.setText(this.getDisplayText("label.inventorySlots", width * height, width, height));
        this.inventoryBox.setOffset(new CGPoint(Math.max(width - 1, 0) * 10, Math.max(height - 1, 0) * 10));
        this.inventoryTitle.setHidden(!isEnabled);
        this.inventorySlot.setHidden(!isEnabled);
        this.inventoryBox.setHidden(!isEnabled);
    }

    private void resolveConflicts() {
        this.blockBed.setEnabled(this.skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK));
        this.blockEnderInventory.setEnabled(this.skinProperties.get(SkinProperty.BLOCK_INVENTORY) == false);
        this.blockInventory.setEnabled(this.skinProperties.get(SkinProperty.BLOCK_ENDER_INVENTORY) == false);
        if (!this.blockBed.isEnabled() && this.blockBed.isSelected()) {
            this.blockBed.setSelected(false);
            this.skinProperties.remove(SkinProperty.BLOCK_BED);
        }
        if (!this.blockEnderInventory.isEnabled() && this.blockEnderInventory.isSelected()) {
            this.blockEnderInventory.setSelected(false);
            this.skinProperties.remove(SkinProperty.BLOCK_ENDER_INVENTORY);
        }
        if (!this.blockInventory.isEnabled() && this.blockInventory.isSelected()) {
            this.blockInventory.setSelected(false);
            this.skinProperties.remove(SkinProperty.BLOCK_INVENTORY);
        }
    }
}

