/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import moe.plushie.armourers_workshop.api.common.IItemParticleProvider;
import moe.plushie.armourers_workshop.api.common.IItemSoundProvider;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.core.item.ConfigurableToolItem;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPaintToolItem
extends ConfigurableToolItem
implements IItemSoundProvider,
IItemParticleProvider {
    public AbstractPaintToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void playSound(UseOnContext context) {
        IRegistryHolder<SoundEvent> soundEvent = this.getItemSoundEvent(context);
        if (soundEvent == null) {
            return;
        }
        if (ModHolidays.APRIL_FOOLS.isHolidayActive()) {
            soundEvent = ModSounds.BOI;
        }
        float pitch = this.getItemSoundPitch(context);
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        if (level.isClientSide()) {
            level.playSound(context.getPlayer(), clickedPos, (SoundEvent)soundEvent.get(), SoundSource.BLOCKS, 1.0f, pitch);
        } else {
            level.playSound(null, clickedPos, (SoundEvent)soundEvent.get(), SoundSource.BLOCKS, 1.0f, pitch);
        }
    }

    @Override
    public void playParticle(UseOnContext context) {
    }

    public float getItemSoundPitch(UseOnContext context) {
        return context.getLevel().getRandom().nextFloat() * 0.1f + 0.9f;
    }

    @Nullable
    public IRegistryHolder<SoundEvent> getItemSoundEvent(UseOnContext context) {
        return null;
    }
}

