/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.menu;

import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.builder.blockentity.ColorMixerBlockEntity;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ColorMixerMenu
extends AbstractBlockEntityMenu<ColorMixerBlockEntity> {
    private final Container inventory = new SimpleContainer(2);

    public ColorMixerMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos access) {
        super((MenuType)menuType, block, containerId, access);
        this.addPlayerSlots((Container)playerInventory, 48, 158);
        this.addCustomSlot(this.inventory, 0, 83, 101);
        this.addCustomSlot(this.inventory, 1, 134, 101);
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, this.inventory);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        return this.quickMoveStack(player, index, this.slots.size() - 1);
    }

    protected void addCustomSlot(final Container inventory, final int slot, int x, int y) {
        this.addSlot(new Slot(inventory, slot, x, y){

            public boolean mayPlace(ItemStack itemStack) {
                return slot == 0 && itemStack.getItem() instanceof IItemPaintable;
            }

            public void setChanged() {
                ItemStack itemStack = inventory.getItem(0);
                Item item = itemStack.getItem();
                if (item instanceof IPaintToolPicker) {
                    IPaintToolPicker toolPicker = (IPaintToolPicker)item;
                    if (inventory.getItem(1).isEmpty()) {
                        ItemStack newItemStack = itemStack.copy();
                        ColorMixerMenu.this.access.execute((world, pos) -> toolPicker.usePickTool(ColorMixerMenu.this.buildContext((Level)world, (BlockPos)pos, newItemStack)));
                        inventory.setItem(0, ItemStack.EMPTY);
                        inventory.setItem(1, newItemStack);
                    }
                }
                super.setChanged();
            }
        });
    }

    protected UseOnContext buildContext(Level level, BlockPos pos, ItemStack itemStack) {
        BlockHitResult traceResult = BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.NORTH, (BlockPos)pos);
        return new UseOnContext(level, null, InteractionHand.OFF_HAND, itemStack, traceResult);
    }
}

