/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.UndoStack;
import moe.plushie.armourers_workshop.builder.data.undo.action.ActionRuntimeException;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class UndoActionPacket
extends CustomPacket {
    private final boolean isRedo;

    public UndoActionPacket(IFriendlyByteBuf buffer) {
        this.isRedo = buffer.readBoolean();
    }

    public UndoActionPacket(boolean isRedo) {
        this.isRedo = isRedo;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isRedo);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        try {
            MutableComponent message;
            UndoStack stack = UndoManager.of(player.getUUID());
            if (this.isRedo) {
                if (!ModPermissions.REDO.accept((Player)player)) {
                    return;
                }
                IUserAction command = stack.redo();
                message = Component.translatable((String)"chat.armourers_workshop.undo.redoing", (Object[])new Object[]{command.name()});
            } else {
                if (!ModPermissions.UNDO.accept((Player)player)) {
                    return;
                }
                IUserAction command = stack.undo();
                message = Component.translatable((String)"chat.armourers_workshop.undo.undoing", (Object[])new Object[]{command.name()});
            }
            player.sendSystemMessage((Component)message);
        }
        catch (ActionRuntimeException exception) {
            player.sendSystemMessage(exception.getComponent());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

