/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.common.IItemParticleProvider;
import moe.plushie.armourers_workshop.api.common.IItemSoundProvider;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public class UpdateBlockColorPacket
extends CustomPacket {
    final InteractionHand hand;
    final GlobalPos clickedPos;
    final BlockHitResult traceResult;
    final CubePaintingEvent paintingEvent;

    public UpdateBlockColorPacket(IFriendlyByteBuf buffer) {
        this.hand = buffer.readEnum(InteractionHand.class);
        this.clickedPos = buffer.readGlobalPos();
        this.traceResult = buffer.readBlockHitResult();
        this.paintingEvent = new CubePaintingEvent(buffer);
    }

    public UpdateBlockColorPacket(UseOnContext context, CubePaintingEvent paintingEvent) {
        this.hand = context.getHand();
        this.clickedPos = GlobalPos.of((ResourceKey)context.getLevel().dimension(), (BlockPos)context.getClickedPos());
        this.traceResult = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside());
        this.paintingEvent = paintingEvent;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum<?>)this.hand);
        buffer.writeGlobalPos(this.clickedPos);
        buffer.writeBlockHitResult(this.traceResult);
        this.paintingEvent.encode(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        ServerLevel level = player.server.getLevel(this.clickedPos.dimension());
        if (level == null) {
            return;
        }
        try {
            ItemStack itemStack = player.getItemInHand(this.hand);
            UseOnContext context = new UseOnContext((Level)level, (Player)player, this.hand, itemStack, this.traceResult);
            CubeChangesCollector collector = new CubeChangesCollector((Level)level);
            this.paintingEvent.apply(collector, context);
            collector.submit(itemStack.getHoverName(), (Player)player);
            this.applyUseEffects(itemStack, context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BlockPos by(IBlockPaintable target) {
        if (target instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)target;
            return blockEntity.getBlockPos();
        }
        return null;
    }

    private void applyUseEffects(ItemStack itemStack, UseOnContext context) {
        Object provider;
        Item item = itemStack.getItem();
        if (item instanceof IItemSoundProvider) {
            provider = (IItemSoundProvider)item;
            provider.playSound(context);
        }
        if (item instanceof IItemParticleProvider) {
            provider = (IItemParticleProvider)item;
            provider.playParticle(context);
        }
    }
}

