/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.builder.data.undo.action.ActionRuntimeException;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CubeChanges
implements IUserAction,
IWorldUpdateTask {
    private final Level level;
    private final BlockPos blockPos;
    private BlockState blockState;
    private CompoundTag nbt;
    private Map<OpenDirection, SkinPaintColor> colors;

    public CubeChanges(Level level, BlockPos blockPos) {
        this.level = level;
        this.blockPos = blockPos;
    }

    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
    }

    public void setCompoundTag(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public void setColor(OpenDirection dir, SkinPaintColor color) {
        if (this.colors == null) {
            this.colors = new HashMap<OpenDirection, SkinPaintColor>();
        }
        this.colors.put(dir, color);
    }

    public void setColors(Map<OpenDirection, SkinPaintColor> colors) {
        this.colors = colors;
    }

    @Override
    public BlockPos blockPos() {
        return this.blockPos;
    }

    @Override
    public BlockState blockState() {
        return this.blockState;
    }

    private boolean isChangeNBT() {
        return this.nbt != null || this.colors != null;
    }

    @Override
    public void prepare() throws RuntimeException {
        if (!this.isChangeNBT()) {
            return;
        }
        if (this.blockState != null) {
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.blockPos);
        if (blockEntity == null) {
            String value = String.format("x=%d, y=%d, z=%d", this.blockPos.getX(), this.blockPos.getY(), this.blockPos.getZ());
            throw new ActionRuntimeException((Component)Component.translatable((String)"chat.armourers_workshop.undo.missingBlock", (Object[])new Object[]{value}));
        }
    }

    @Override
    public IUserAction apply() throws RuntimeException {
        BlockEntity blockEntity2;
        boolean isChangedNBT = false;
        CubeChanges changes = new CubeChanges(this.level, this.blockPos);
        if (this.blockState != null) {
            changes.setBlockState(this.level.getBlockState(this.blockPos));
            isChangedNBT = true;
        }
        if (this.nbt != null) {
            isChangedNBT = true;
        }
        if (isChangedNBT) {
            Objects.flatMap(this.level.getBlockEntity(this.blockPos), blockEntity -> {
                CompoundTag newTag = StorageAPI.saveFullData(blockEntity, this.level.registryAccess());
                changes.setCompoundTag(newTag);
                return newTag;
            });
        } else if (this.colors != null && (blockEntity2 = this.level.getBlockEntity(this.blockPos)) instanceof IBlockPaintable) {
            IBlockPaintable target = (IBlockPaintable)blockEntity2;
            HashMap<OpenDirection, SkinPaintColor> oldValue = new HashMap<OpenDirection, SkinPaintColor>();
            for (OpenDirection direction : this.colors.keySet()) {
                SkinPaintColor paintColor = target.getColor(direction);
                if (paintColor == null) {
                    paintColor = SkinPaintColor.CLEAR;
                }
                oldValue.put(direction, paintColor);
            }
            changes.setColors(oldValue);
        }
        WorldUpdater.getInstance().submit(this);
        return changes;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public InteractionResult run(Level level) {
        if (!level.isLoaded(this.blockPos)) {
            return InteractionResult.PASS;
        }
        int changes = 0;
        if (this.blockState != null && !this.blockState.equals(level.getBlockState(this.blockPos))) {
            level.setBlock(this.blockPos, this.blockState, 3);
            ++changes;
        }
        BlockEntity blockEntity = null;
        if (this.isChangeNBT()) {
            blockEntity = level.getBlockEntity(this.blockPos);
        }
        if (this.nbt != null && blockEntity != null) {
            StorageAPI.loadFullData(blockEntity, this.nbt, level.registryAccess());
            ++changes;
        }
        if (this.colors != null && blockEntity instanceof IBlockPaintable) {
            IBlockPaintable paintable = (IBlockPaintable)blockEntity;
            paintable.setColors(this.colors);
            ++changes;
        }
        if (changes == 0) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }
}

