/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.function.Consumer;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class WorldBlockUpdateTask
implements IWorldUpdateTask {
    Level level;
    BlockPos blockPos;
    BlockState blockState;
    CompoundTag nbt;
    Predicate<BlockState> validator;
    Consumer<BlockState> modifier;
    private int blockFlags = 3;

    public WorldBlockUpdateTask(Level level, BlockPos blockPos, BlockState blockState) {
        this(level, blockPos, blockState, null);
    }

    public WorldBlockUpdateTask(Level level, BlockPos blockPos, BlockState blockState, CompoundTag nbt) {
        this.level = level;
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.nbt = nbt;
    }

    public void setValidator(Predicate<BlockState> validator) {
        this.validator = validator;
    }

    public void setModifier(Consumer<BlockState> modifier) {
        this.modifier = modifier;
    }

    public void setBlockFlags(int blockFlags) {
        this.blockFlags = blockFlags;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public BlockPos blockPos() {
        return this.blockPos;
    }

    @Override
    public BlockState blockState() {
        return this.blockState;
    }

    @Override
    public InteractionResult run(Level level) {
        BlockEntity blockEntity;
        if (!level.isLoaded(this.blockPos)) {
            return InteractionResult.PASS;
        }
        if (this.validator != null && !this.validator.test(level.getBlockState(this.blockPos))) {
            return InteractionResult.PASS;
        }
        level.setBlock(this.blockPos, this.blockState, this.blockFlags);
        if (this.nbt != null && (blockEntity = level.getBlockEntity(this.blockPos)) != null) {
            StorageAPI.loadFullData(blockEntity, this.nbt, level.registryAccess());
        }
        if (this.modifier != null) {
            this.modifier.accept(this.blockState);
        }
        return InteractionResult.SUCCESS;
    }
}

