/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.math.IVector3i;
import moe.plushie.armourers_workshop.builder.block.SkinCubeBlock;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.CubeWrapper;
import moe.plushie.armourers_workshop.core.data.OptionalDirection;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.collection.SkinGeometrySetV1;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.SkinSaveException;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class WorldUtils {
    public static Skin saveSkinFromWorld(Level level, CubeTransform transform, SkinProperties skinProps, SkinType skinType, SkinPaintData paintData) throws SkinSaveException {
        SkinPart testPart;
        Skin skin;
        ArrayList<SkinPart> parts = new ArrayList<SkinPart>();
        if (skinType == SkinTypes.BLOCK) {
            SkinPart skinPart;
            Object partType = SkinPartTypes.BLOCK;
            if (skinProps.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue()) {
                partType = SkinPartTypes.BLOCK_MULTI;
            }
            if ((skinPart = WorldUtils.saveArmourPart(level, transform, (SkinPartType)partType, true)) != null) {
                parts.add(skinPart);
            }
        } else {
            for (SkinPartType skinPartType : skinType.parts()) {
                SkinPart skinPart = WorldUtils.saveArmourPart(level, transform, skinPartType, true);
                if (skinPart == null) continue;
                parts.add(skinPart);
            }
        }
        Skin.Builder builder = new Skin.Builder(skinType);
        builder.properties(skinProps);
        builder.paintData(paintData);
        builder.parts(parts);
        if (paintData != null) {
            builder.version(20);
        }
        if ((skin = builder.build()).parts().isEmpty() && skin.paintData() == null) {
            throw SkinSaveException.Type.NO_DATA.build("noting", new Object[0]);
        }
        for (SkinPartType skinPartType : skinType.parts()) {
            if (!skinPartType.isPartRequired()) continue;
            boolean havePart = false;
            for (SkinPart part : skin.parts()) {
                if (skinPartType != part.type()) continue;
                havePart = true;
                break;
            }
            if (havePart) continue;
            throw SkinSaveException.Type.MISSING_PARTS.build("missingPart", TranslateUtils.Name.of(skinPartType));
        }
        if (skinProps.get(SkinProperty.BLOCK_BED).booleanValue() && skinProps.get(SkinProperty.BLOCK_SEAT).booleanValue()) {
            throw SkinSaveException.Type.BED_AND_SEAT.build("conflictBedSeat", new Object[0]);
        }
        if (skinType == SkinTypes.BLOCK && skinProps.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue() && (testPart = WorldUtils.saveArmourPart(level, transform, SkinPartTypes.BLOCK, true)) == null) {
            throw SkinSaveException.Type.INVALID_MULTIBLOCK.build("missingMainBlock", new Object[0]);
        }
        return skin;
    }

    private static SkinPart saveArmourPart(Level level, CubeTransform transform, SkinPartType partType, boolean markerCheck) throws SkinSaveException {
        int cubeCount = WorldUtils.getNumberOfCubesInPart(level, transform, partType);
        if (cubeCount < 1) {
            return null;
        }
        SkinGeometrySetV1 geometries = new SkinGeometrySetV1(cubeCount);
        ArrayList<SkinMarker> markerBlocks = new ArrayList<SkinMarker>();
        OpenRectangle3i buildSpace = partType.buildingSpace();
        OpenVector3i offset = partType.offset();
        int i = 0;
        for (int ix = 0; ix < buildSpace.width(); ++ix) {
            for (int iy = 0; iy < buildSpace.height(); ++iy) {
                for (int iz = 0; iz < buildSpace.depth(); ++iz) {
                    BlockPos target = transform.mul(ix + -offset.x() + buildSpace.x(), iy + -offset.y(), iz + offset.z() + buildSpace.z());
                    int xOrigin = -ix + -buildSpace.x();
                    int yOrigin = -iy + -buildSpace.y();
                    int zOrigin = -iz + -buildSpace.z();
                    BlockState targetState = level.getBlockState(target);
                    if (!(targetState.getBlock() instanceof SkinCubeBlock)) continue;
                    WorldUtils.saveArmourBlockToList(level, transform, target, xOrigin - 1, yOrigin - 1, -zOrigin, geometries.get(i), markerBlocks);
                    ++i;
                }
            }
        }
        if (markerCheck) {
            if (partType.minimumMarkersNeeded() > markerBlocks.size()) {
                throw SkinSaveException.Type.MARKER_ERROR.build("missingMarker", TranslateUtils.Name.of(partType));
            }
            if (markerBlocks.size() > partType.maximumMarkersNeeded()) {
                throw SkinSaveException.Type.MARKER_ERROR.build("tooManyMarkers", TranslateUtils.Name.of(partType));
            }
        }
        SkinPart.Builder builder = new SkinPart.Builder(partType);
        builder.geometries(geometries);
        builder.markers(markerBlocks);
        return builder.build();
    }

    private static void saveArmourBlockToList(Level level, CubeTransform transform, BlockPos pos, int ix, int iy, int iz, SkinCube cube, ArrayList<SkinMarker> markerBlocks) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof IBlockPaintable)) {
            return;
        }
        IBlockPaintable target = (IBlockPaintable)blockEntity;
        BlockState blockState = blockEntity.getBlockState();
        OptionalDirection marker = SkinCubeBlock.getMarker(blockState);
        cube.setType(SkinGeometryTypes.byBlock(blockState.getBlock()));
        cube.setBoundingBox(new OpenRectangle3f(ix, iy, iz, 1.0f, 1.0f, 1.0f));
        for (OpenDirection dir : OpenDirection.values()) {
            SkinPaintColor paintColor = target.getColor(dir);
            OpenDirection resolvedDir = transform.invRotate(dir);
            cube.setPaintColor(resolvedDir, paintColor);
        }
        if (marker != OptionalDirection.NONE) {
            OpenDirection markFacing = transform.invRotate(marker.direction());
            OptionalDirection resolvedMarker = OptionalDirection.of(markFacing);
            markerBlocks.add(new SkinMarker((byte)ix, (byte)iy, (byte)iz, (byte)resolvedMarker.ordinal()));
        }
    }

    public static void loadSkinIntoWorld(CubeChangesCollector collector, CubeTransform transform, Skin skin) {
        for (SkinPart part : skin.parts()) {
            WorldUtils.loadSkinPartIntoWorld(collector, transform, part, false);
        }
    }

    private static void loadSkinPartIntoWorld(CubeChangesCollector collector, CubeTransform transform, SkinPart partData, boolean mirror) {
        SkinPartType skinPart = partData.type();
        OpenRectangle3i buildSpace = skinPart.buildingSpace();
        OpenVector3i offset = skinPart.offset();
        for (SkinCube cube : Collections.collect(partData.geometries(), SkinCube.class)) {
            OpenVector3i blockPos = cube.blockPos();
            SkinGeometryType geometryType = cube.type();
            OptionalDirection markerFacing = OptionalDirection.NONE;
            for (SkinMarker marker : partData.markers()) {
                OpenDirection dir = marker.direction();
                if (dir == null || !blockPos.equals(marker.position())) continue;
                OptionalDirection resolvedMarker = OptionalDirection.of(WorldUtils.getResolvedDirection(dir, mirror));
                markerFacing = OptionalDirection.of(transform.rotate(resolvedMarker.direction()));
                break;
            }
            BlockPos origin = new BlockPos(-offset.x(), -offset.y() + -buildSpace.y(), offset.z());
            WorldUtils.loadSkinBlockIntoWorld(collector, transform, origin, geometryType, blockPos, markerFacing, cube, mirror);
        }
    }

    private static void loadSkinBlockIntoWorld(CubeChangesCollector collector, CubeTransform transform, BlockPos origin, SkinGeometryType geometryType, IVector3i cubePos, OptionalDirection markerFacing, SkinCube cube, boolean mirror) {
        BlockPos target;
        CubeWrapper targetCube;
        int shiftX = -cubePos.x() - 1;
        int shiftY = cubePos.y() + 1;
        int shiftZ = cubePos.z();
        if (mirror) {
            shiftX = cubePos.x();
        }
        if ((targetCube = collector.cubeAtPos(target = transform.mul(shiftX + origin.getX(), origin.getY() - shiftY, shiftZ + origin.getZ()))).is((Block)ModBlocks.BOUNDING_BOX.get())) {
            targetCube.setBlockStateAndTag(Blocks.AIR.defaultBlockState(), null);
        }
        Block targetBlock = geometryType.block();
        BlockState targetState = SkinCubeBlock.setMarker(targetBlock.defaultBlockState(), markerFacing);
        HashMap<OpenDirection, SkinPaintColor> colors = new HashMap<OpenDirection, SkinPaintColor>();
        for (OpenDirection dir : OpenDirection.values()) {
            SkinPaintColor paintColor = cube.getPaintColor(dir);
            OpenDirection resolvedDir = WorldUtils.getResolvedDirection(dir, mirror);
            colors.put(transform.rotate(resolvedDir), paintColor);
        }
        targetCube.setBlockStateAndColors(targetState, colors);
    }

    public static void copyPaintData(SkinPaintData srcData, EntityTextureModel.Box srcBox, SkinPaintData destData, EntityTextureModel.Box destBox, boolean isMirrorX) {
        srcData.copyTo(srcBox, destData, destBox, isMirrorX);
    }

    public static void clearPaintData(SkinPaintData srcData, EntityTextureModel.Box srcBox) {
        srcBox.forEach((texturePos, x, y, z, dir) -> srcData.setColor(texturePos, 0));
    }

    public static void replaceCubes(CubeChangesCollector collector, CubeTransform transform, SkinType skinType, SkinProperties skinProps, CubeReplacingEvent event) {
        for (SkinPartType skinPartType : skinType.parts()) {
            for (OpenVector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPartType)) {
                WorldUtils.replaceCube(collector, transform.mul(offset), event);
            }
        }
    }

    public static void replaceCube(CubeChangesCollector collector, BlockPos pos, CubeReplacingEvent event) {
        CubeWrapper cube = collector.cubeAtPos(pos);
        if (event.accept(cube)) {
            event.apply(cube);
        }
    }

    public static void copyCubes(CubeChangesCollector collector, CubeTransform transform, SkinType skinType, SkinProperties skinProps, SkinPartType srcType, SkinPartType destType, boolean mirror) throws SkinSaveException {
        SkinPart skinPart = WorldUtils.saveArmourPart(collector.level(), transform, srcType, false);
        if (skinPart != null) {
            SkinPart.Builder builder = new SkinPart.Builder(destType);
            builder.name(skinPart.name());
            builder.transform(skinPart.transform());
            builder.geometries((SkinGeometrySet<?>)skinPart.geometries());
            builder.markers((List<SkinMarker>)skinPart.markers());
            builder.children((List<SkinPart>)skinPart.children());
            WorldUtils.loadSkinPartIntoWorld(collector, transform, builder.build(), mirror);
        }
    }

    public static int clearMarkers(CubeChangesCollector collector, CubeTransform transform, SkinType skinType, SkinProperties skinProps, SkinPartType partType) {
        int blockCount = 0;
        for (SkinPartType skinPartType : skinType.parts()) {
            if (partType != SkinPartTypes.UNKNOWN && partType != skinPartType) continue;
            if (skinType == SkinTypes.BLOCK) {
                boolean multiblock = skinProps.get(SkinProperty.BLOCK_MULTIBLOCK);
                if (skinPartType == SkinPartTypes.BLOCK && !multiblock) {
                    blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, skinPartType);
                }
                if (skinPartType != SkinPartTypes.BLOCK_MULTI || !multiblock) continue;
                blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, skinPartType);
                continue;
            }
            blockCount += WorldUtils.clearMarkersForSkinPart(collector, transform, skinPartType);
        }
        return blockCount;
    }

    private static int clearMarkersForSkinPart(CubeChangesCollector collector, CubeTransform transform, SkinPartType skinPart) {
        int blockCount = 0;
        for (OpenVector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            CubeWrapper cube = collector.cubeAtPos(transform.mul(offset));
            BlockState targetState = cube.blockState();
            if (!targetState.hasProperty((Property)SkinCubeBlock.MARKER) || SkinCubeBlock.getMarker(targetState) == OptionalDirection.NONE) continue;
            cube.setBlockState(SkinCubeBlock.setMarker(targetState, OptionalDirection.NONE));
            ++blockCount;
        }
        return blockCount;
    }

    public static int clearCubes(CubeChangesCollector collector, CubeTransform transform, SkinType skinType, SkinProperties skinProps, SkinPartType partType) {
        int blockCount = 0;
        for (SkinPartType skinPartType : skinType.parts()) {
            if (partType != SkinPartTypes.UNKNOWN && partType != skinPartType) continue;
            if (skinType == SkinTypes.BLOCK) {
                boolean multiblock = skinProps.get(SkinProperty.BLOCK_MULTIBLOCK);
                if (skinPartType == SkinPartTypes.BLOCK && !multiblock) {
                    blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, skinPartType);
                }
                if (skinPartType != SkinPartTypes.BLOCK_MULTI || !multiblock) continue;
                blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, skinPartType);
                continue;
            }
            blockCount += WorldUtils.clearEquipmentCubesForSkinPart(collector, transform, skinPartType);
        }
        return blockCount;
    }

    private static int clearEquipmentCubesForSkinPart(CubeChangesCollector collector, CubeTransform transform, SkinPartType skinPart) {
        int blockCount = 0;
        for (OpenVector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            CubeWrapper cube = collector.cubeAtPos(transform.mul(offset));
            if (!cube.is(SkinCubeBlock.class)) continue;
            cube.setBlockStateAndTag(Blocks.AIR.defaultBlockState(), null);
            ++blockCount;
        }
        return blockCount;
    }

    public static OpenRectangle3i getResolvedBuildingSpace(SkinPartType skinPart) {
        OpenVector3i origin = skinPart.offset();
        OpenRectangle3i buildSpace = skinPart.buildingSpace();
        int dx = -origin.x() + buildSpace.x();
        int dy = -origin.y();
        int dz = origin.z() + buildSpace.z();
        return new OpenRectangle3i(dx, dy, dz, buildSpace.width(), buildSpace.height(), buildSpace.depth());
    }

    private static Iterable<OpenVector3i> getResolvedBuildingSpace2(SkinPartType skinPart) {
        return WorldUtils.getResolvedBuildingSpace(skinPart).enumerateZYX();
    }

    private static int getNumberOfCubesInPart(Level level, CubeTransform transform, SkinPartType skinPart) {
        int cubeCount = 0;
        for (OpenVector3i offset : WorldUtils.getResolvedBuildingSpace2(skinPart)) {
            BlockState blockState = level.getBlockState(transform.mul(offset));
            if (!(blockState.getBlock() instanceof SkinCubeBlock)) continue;
            ++cubeCount;
        }
        return cubeCount;
    }

    private static OpenDirection getResolvedDirection(OpenDirection dir, boolean mirror) {
        if (mirror && dir.axis() == OpenDirection.Axis.X) {
            return dir.opposite();
        }
        return dir;
    }
}

