/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.core.utils.Executors;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractCustomProfileTextureLoader {
    public static void load(GameProfile profile, ResultHandler handler) {
        int timeout = 30000;
        AbstractCustomProfileTextureLoader.load(profile, System.currentTimeMillis() + (long)timeout, handler);
    }

    private static void load(GameProfile profile, long endTime, ResultHandler handler) {
        EnvironmentManager.getClient().getSkinManager().getOrLoad(profile).thenAcceptAsync(skin -> {
            String url = skin.textureUrl();
            OpenResourceLocation location = OpenResourceLocation.create(skin.texture());
            String modelType = skin.model().id();
            if (profile.getProperties().isEmpty()) {
                handler.accept(location, url, modelType);
                return;
            }
            if (url == null && System.currentTimeMillis() < endTime) {
                Executors.sleep(500L);
                AbstractCustomProfileTextureLoader.load(profile, endTime, handler);
                return;
            }
            handler.accept(location, url, modelType);
        });
    }

    public static interface ResultHandler {
        public void accept(OpenResourceLocation var1, String var2, String var3);
    }
}

