/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.RenderType.ColorLogicProvider;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexFormat;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class AbstractRenderTypeImpl
extends RenderType {
    private static final Map<SkinVertexFormat, Supplier<IRenderTypeBuilder>> MAPPER = AbstractRenderTypeImpl._make(it -> {
        it.put(SkinVertexFormat.LINE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.DEBUG_LINES, POSITION_COLOR_SHADER));
        it.put(SkinVertexFormat.LINE_STRIP, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.DEBUG_LINE_STRIP, POSITION_COLOR_SHADER));
        it.put(SkinVertexFormat.IMAGE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, VertexFormat.Mode.QUADS, POSITION_COLOR_TEX_LIGHTMAP_SHADER).overlay().lightmap());
        it.put(SkinVertexFormat.BLIT_MASK, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.TRIANGLES, POSITION_COLOR_SHADER));
        it.put(SkinVertexFormat.GUI_COLOR, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS, POSITION_COLOR_SHADER));
        it.put(SkinVertexFormat.GUI_IMAGE, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS, POSITION_TEX_SHADER));
        it.put(SkinVertexFormat.GUI_HIGHLIGHTED_TEXT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS, POSITION_SHADER));
        it.put(SkinVertexFormat.BLOCK, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_SOLID_SHADER));
        it.put(SkinVertexFormat.BLOCK_CUTOUT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_CUTOUT_SHADER));
        it.put(SkinVertexFormat.ENTITY_CUTOUT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_CUTOUT_SHADER));
        it.put(SkinVertexFormat.ENTITY_CUTOUT_NO_CULL, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_CUTOUT_NO_CULL_SHADER));
        it.put(SkinVertexFormat.ENTITY_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_TRANSLUCENT_CULL_SHADER));
        it.put(SkinVertexFormat.ENTITY_ALPHA, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_ALPHA_SHADER));
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_SOLID_SHADER).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_SHADOW_SHADER).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_SOLID_SHADER).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_BLOCK_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_SHADOW_SHADER).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_CUTOUT_SHADER).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENERGY_SWIRL_SHADER).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENTITY_SOLID_SHADER).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_CUBE_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS, RENDERTYPE_ENERGY_SWIRL_SHADER).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_SOLID, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES, RENDERTYPE_ENTITY_CUTOUT_SHADER).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_LIGHTING, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES, RENDERTYPE_ENERGY_SWIRL_SHADER).overlay().lightmap().emissive());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES, RENDERTYPE_ENTITY_SOLID_SHADER).overlay().lightmap());
        it.put(SkinVertexFormat.SKIN_MESH_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderTypeImpl._builder(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES, RENDERTYPE_ENERGY_SWIRL_SHADER).overlay().lightmap().emissive());
    });

    public AbstractRenderTypeImpl(String name, RenderType delegate, boolean affectsCrumbling, boolean sortUpload, Runnable setupRenderState, Runnable clearRenderState) {
        super(name, delegate.format(), delegate.mode(), delegate.bufferSize(), affectsCrumbling, sortUpload, () -> {
            delegate.setupRenderState();
            setupRenderState.run();
        }, () -> {
            clearRenderState.run();
            delegate.clearRenderState();
        });
    }

    public static IRenderTypeBuilder builder(SkinVertexFormat format) {
        Supplier<IRenderTypeBuilder> provider = MAPPER.get((Object)format);
        if (provider != null) {
            IRenderTypeBuilder builder = provider.get();
            if (builder instanceof Builder) {
                Builder builder1 = (Builder)builder;
                builder1.format(format);
            }
            return builder;
        }
        throw new RuntimeException("can't supported render mode");
    }

    private static Builder _builder(VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader) {
        Builder builder = new Builder(format, mode);
        builder.stateBuilder.setShaderState(shader);
        return builder;
    }

    private static <T, U> HashMap<T, U> _make(Consumer<HashMap<T, U>> consumer) {
        HashMap map = new HashMap();
        consumer.accept(map);
        return map;
    }

    public static class Builder
    extends AbstractRenderType.Builder {
        private static final Map<IRenderType.Texturing, RenderStateShard.TexturingStateShard> TABLE_TEXTURING = AbstractRenderTypeImpl._make(it -> {});
        private static final Map<IRenderType.Target, RenderStateShard.OutputStateShard> TABLE_OUTPUT = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.Target.MAIN, MAIN_TARGET);
            it.put(IRenderType.Target.OUTLINE, OUTLINE_TARGET);
            it.put(IRenderType.Target.TRANSLUCENT, TRANSLUCENT_TARGET);
            it.put(IRenderType.Target.CLOUDS, CLOUDS_TARGET);
            it.put(IRenderType.Target.WEATHER, WEATHER_TARGET);
            it.put(IRenderType.Target.PARTICLES, PARTICLES_TARGET);
            it.put(IRenderType.Target.ITEM_ENTITY, ITEM_ENTITY_TARGET);
        });
        private static final Map<IRenderType.Transparency, RenderStateShard.TransparencyStateShard> TABLE_TRANSPARENCY = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.Transparency.DEFAULT, TRANSLUCENT_TRANSPARENCY);
            it.put(IRenderType.Transparency.TRANSLUCENT, TRANSLUCENT_TRANSPARENCY);
            it.put(IRenderType.Transparency.NONE, NO_TRANSPARENCY);
        });
        private static final Map<IRenderType.WriteMask, RenderStateShard.WriteMaskStateShard> TABLE_WRITE_MASK = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.WriteMask.NONE, new RenderStateShard.WriteMaskStateShard(false, false));
            it.put(IRenderType.WriteMask.COLOR_DEPTH_WRITE, COLOR_DEPTH_WRITE);
            it.put(IRenderType.WriteMask.COLOR_WRITE, COLOR_WRITE);
            it.put(IRenderType.WriteMask.DEPTH_WRITE, DEPTH_WRITE);
        });
        private static final Map<IRenderType.DepthTest, RenderStateShard.DepthTestStateShard> TABLE_DEPTH_TEST = AbstractRenderTypeImpl._make(it -> {
            it.put(IRenderType.DepthTest.NONE, NO_DEPTH_TEST);
            it.put(IRenderType.DepthTest.EQUAL, EQUAL_DEPTH_TEST);
            it.put(IRenderType.DepthTest.LESS_EQUAL, LEQUAL_DEPTH_TEST);
        });
        boolean isOutline = false;
        boolean affectsCrumbling = false;
        boolean sortOnUpload = false;
        RenderType.CompositeState.CompositeStateBuilder stateBuilder = RenderType.CompositeState.builder();
        final VertexFormat format;
        final VertexFormat.Mode mode;

        private Builder(VertexFormat format, VertexFormat.Mode mode) {
            this.format = format;
            this.mode = mode;
            this.setupDefault();
        }

        private void setupDefault() {
            this.stateBuilder = this.stateBuilder.setCullState(NO_CULL);
        }

        @Override
        public IRenderTypeBuilder texture(IResourceLocation texture, boolean blur, boolean mipmap) {
            this.stateBuilder = this.stateBuilder.setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture.toLocation(), blur, mipmap));
            return this;
        }

        @Override
        public IRenderTypeBuilder texturing(IRenderType.Texturing texturing) {
            this.stateBuilder = this.stateBuilder.setTexturingState(TABLE_TEXTURING.getOrDefault((Object)texturing, DEFAULT_TEXTURING));
            return this;
        }

        @Override
        public IRenderTypeBuilder target(IRenderType.Target target) {
            this.stateBuilder = this.stateBuilder.setOutputState(TABLE_OUTPUT.getOrDefault((Object)target, MAIN_TARGET));
            return super.target(target);
        }

        @Override
        public IRenderTypeBuilder transparency(IRenderType.Transparency transparency) {
            this.stateBuilder = this.stateBuilder.setTransparencyState(TABLE_TRANSPARENCY.getOrDefault((Object)transparency, NO_TRANSPARENCY));
            return super.transparency(transparency);
        }

        @Override
        public IRenderTypeBuilder writeMask(IRenderType.WriteMask mask) {
            this.stateBuilder = this.stateBuilder.setWriteMaskState(TABLE_WRITE_MASK.getOrDefault((Object)mask, COLOR_DEPTH_WRITE));
            return this;
        }

        @Override
        public IRenderTypeBuilder depthTest(IRenderType.DepthTest test) {
            this.stateBuilder = this.stateBuilder.setDepthTestState(TABLE_DEPTH_TEST.getOrDefault((Object)test, NO_DEPTH_TEST));
            return this;
        }

        @Override
        public IRenderTypeBuilder colorLogic(IRenderType.ColorLogic state) {
            this.stateBuilder = ColorLogicProvider.CompositeState.CompositeStateBuilder.setColorLogicState(this.stateBuilder, state);
            return this;
        }

        @Override
        public IRenderTypeBuilder polygonOffset(float factor, float units) {
            this.stateBuilder = this.stateBuilder.setLayeringState(new RenderStateShard.LayeringStateShard("aw_polygon_offset_" + units, () -> {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)factor, (float)units);
            }, () -> {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }));
            return this;
        }

        @Override
        public IRenderTypeBuilder lineWidth(float width) {
            this.stateBuilder = this.stateBuilder.setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(width)));
            return this;
        }

        @Override
        public IRenderTypeBuilder stroke(float width) {
            this.stateBuilder = this.stateBuilder.setLayeringState(new RenderStateShard.LayeringStateShard("aw_custom_line", () -> {
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glLineWidth((float)width);
            }, () -> GL11.glPolygonMode((int)1032, (int)6914)));
            return this;
        }

        @Override
        public IRenderTypeBuilder cull() {
            this.stateBuilder = this.stateBuilder.setCullState(CULL);
            return this;
        }

        @Override
        public IRenderTypeBuilder lightmap() {
            this.stateBuilder = this.stateBuilder.setLightmapState(LIGHTMAP);
            return this;
        }

        @Override
        public IRenderTypeBuilder overlay() {
            this.stateBuilder = this.stateBuilder.setOverlayState(OVERLAY);
            return this;
        }

        @Override
        public IRenderTypeBuilder outline() {
            this.isOutline = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder crumbling() {
            this.affectsCrumbling = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder sortOnUpload() {
            this.sortOnUpload = true;
            return this;
        }

        @Override
        public IRenderType build(String name) {
            AbstractRenderType renderType = AbstractRenderType.of((RenderType)RenderType.create((String)name, (VertexFormat)this.format, (VertexFormat.Mode)this.mode, (int)256, (boolean)this.affectsCrumbling, (boolean)this.sortOnUpload, (RenderType.CompositeState)this.stateBuilder.createCompositeState(this.isOutline)));
            renderType.apply(this.updater);
            return renderType;
        }

        public Builder or(Function<RenderType.CompositeState.CompositeStateBuilder, RenderType.CompositeState.CompositeStateBuilder> builder) {
            this.stateBuilder = builder.apply(this.stateBuilder);
            return this;
        }
    }
}

