/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractTooltipContext;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHorizontalBlockImpl
extends HorizontalDirectionalBlock {
    public AbstractHorizontalBlockImpl(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends AbstractHorizontalBlockImpl> codec() {
        return null;
    }

    public final List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        return this.getDrops(blockState, new LootContextBuilder(builder));
    }

    public List<ItemStack> getDrops(BlockState blockState, ILootContext context) {
        return super.getDrops(blockState, ((LootContextBuilder)context).builder);
    }

    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        return this.destroyByPlayer(level, blockPos, blockState, player);
    }

    public BlockState destroyByPlayer(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (blockState.getBlock() != this) {
            return blockState.useWithoutItem(level, player, blockHitResult.withPosition(blockPos));
        }
        return super.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    public void appendHoverText(ItemStack itemStack, List<Component> tooltips, ITooltipContext context) {
        AbstractTooltipContext context1 = (AbstractTooltipContext)Objects.unsafeCast(context);
        super.appendHoverText(itemStack, (Item.TooltipContext)context1.context, tooltips, context1.flag);
    }

    public final void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltips, TooltipFlag tooltipFlag) {
        this.appendHoverText(itemStack, tooltips, new AbstractTooltipContext<Item.TooltipContext>(tooltipContext, tooltipFlag));
    }

    public static class LootContextBuilder
    implements ILootContext {
        private static final Map<ILootContextParam<?>, LootContextParam<?>> KEYS = Collections.immutableMap(builder -> {
            builder.put(ILootContextParam.THIS_ENTITY, (Object)LootContextParams.THIS_ENTITY);
            builder.put(ILootContextParam.LAST_DAMAGE_PLAYER, (Object)LootContextParams.LAST_DAMAGE_PLAYER);
            builder.put(ILootContextParam.DAMAGE_SOURCE, (Object)LootContextParams.DAMAGE_SOURCE);
            builder.put(ILootContextParam.ATTACKING_ENTITY, (Object)LootContextParams.ATTACKING_ENTITY);
            builder.put(ILootContextParam.DIRECT_ATTACKING_ENTITY, (Object)LootContextParams.DIRECT_ATTACKING_ENTITY);
            builder.put(ILootContextParam.ORIGIN, (Object)LootContextParams.ORIGIN);
            builder.put(ILootContextParam.BLOCK_STATE, (Object)LootContextParams.BLOCK_STATE);
            builder.put(ILootContextParam.BLOCK_ENTITY, (Object)LootContextParams.BLOCK_ENTITY);
            builder.put(ILootContextParam.TOOL, (Object)LootContextParams.TOOL);
            builder.put(ILootContextParam.EXPLOSION_RADIUS, (Object)LootContextParams.EXPLOSION_RADIUS);
        });
        private final LootParams.Builder builder;

        public LootContextBuilder(LootParams.Builder builder) {
            this.builder = builder;
        }

        @Override
        public <T> T getParameter(ILootContextParam<T> param) {
            Object value = this.builder.getParameter(KEYS.get(param));
            return param.valueType().cast(this.convert(value));
        }

        @Override
        @Nullable
        public <T> T getOptionalParameter(ILootContextParam<T> param) {
            Object value = this.builder.getOptionalParameter(KEYS.get(param));
            if (value != null) {
                return param.valueType().cast(this.convert(value));
            }
            return null;
        }

        private Object convert(Object value) {
            Vec3 pos = Objects.safeCast(value, Vec3.class);
            if (pos != null) {
                return new OpenVector3f(pos.x, pos.y, pos.z);
            }
            return value;
        }
    }
}

