/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class AbstractDataSerializer
implements IDataSerializer {
    protected final CompoundTag tag;
    protected final HolderLookup.Provider provider;
    protected final DynamicOps<Tag> ops;

    public AbstractDataSerializer(CompoundTag tag, @Nullable Object context) {
        this.tag = tag;
        this.provider = AbstractDataSerializer.unwrap(context);
        this.ops = this.provider != null ? this.provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE) : NbtOps.INSTANCE;
    }

    public static AbstractDataSerializer wrap(CompoundTag tag, @Nullable Object context) {
        return new AbstractDataSerializer(tag, context);
    }

    private static HolderLookup.Provider unwrap(@Nullable Object context) {
        if (context instanceof HolderLookup.Provider) {
            HolderLookup.Provider provider = (HolderLookup.Provider)context;
            return provider;
        }
        if (context instanceof Level) {
            Level level = (Level)context;
            return level.registryAccess();
        }
        if (context instanceof Entity) {
            Entity entity = (Entity)context;
            return entity.registryAccess();
        }
        if (context instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)context;
            return AbstractDataSerializer.unwrap(blockEntity.getLevel());
        }
        return null;
    }

    @Override
    public <T> T read(IDataSerializerKey<T> key) {
        Object value2;
        Codec<T> codec;
        Optional value;
        String name = key.name();
        if (this.tag != null && this.tag.contains(name) && (value = (codec = key.codec().codec()).decode(this.ops, (Object)this.tag.get(key.name())).result()).isPresent() && (value2 = ((Pair)value.get()).getFirst()) != null) {
            return (T)value2;
        }
        Supplier<T> constructor = key.constructor();
        if (constructor != null) {
            return constructor.get();
        }
        return key.defaultValue();
    }

    @Override
    public <T> void write(IDataSerializerKey<T> key, T value) {
        if (this.tag == null) {
            return;
        }
        T defaultValue = key.defaultValue();
        if (defaultValue == value || Objects.equals(defaultValue, value)) {
            return;
        }
        String name = key.name();
        Codec<T> codec = key.codec().codec();
        codec.encodeStart(this.ops, value).result().ifPresent(it -> this.tag.put(name, it));
    }
}

