/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import io.netty.buffer.ByteBuf;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractFriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;

public class AbstractEntityDataSerializer<T>
implements IEntitySerializer<T> {
    private final StreamCodec<? super RegistryFriendlyByteBuf, T> codec;

    protected AbstractEntityDataSerializer(EntityDataSerializer<T> serializer) {
        this.codec = serializer.codec();
    }

    public static <T> Proxy<T> create(IEntitySerializer<T> serializer) {
        return new Proxy<T>(serializer);
    }

    public static <T> AbstractEntityDataSerializer<T> wrap(EntityDataAccessor<T> accessor) {
        return AbstractEntityDataSerializer.wrap(accessor.serializer());
    }

    public static <T> AbstractEntityDataSerializer<T> wrap(EntityDataSerializer<T> serializer) {
        return new AbstractEntityDataSerializer<T>(serializer);
    }

    @Override
    public T read(IFriendlyByteBuf buffer) {
        return (T)this.codec.decode((Object)((RegistryFriendlyByteBuf)buffer.asByteBuf()));
    }

    @Override
    public void write(IFriendlyByteBuf buffer, T value) {
        this.codec.encode((Object)((RegistryFriendlyByteBuf)buffer.asByteBuf()), value);
    }

    public static class Proxy<T>
    implements EntityDataSerializer<T> {
        private final StreamCodec<? super RegistryFriendlyByteBuf, T> codec;
        private final IEntitySerializer<T> serializer;

        public Proxy(IEntitySerializer<T> serializer) {
            this.serializer = serializer;
            this.codec = StreamCodec.of(this::write, this::read);
        }

        public void write(RegistryFriendlyByteBuf buf, T object) {
            this.serializer.write(AbstractFriendlyByteBuf.wrap((ByteBuf)buf), object);
        }

        public T read(RegistryFriendlyByteBuf buf) {
            return this.serializer.read(AbstractFriendlyByteBuf.wrap((ByteBuf)buf));
        }

        public T copy(T object) {
            return object;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, T> codec() {
            return this.codec;
        }

        public String toString() {
            return this.serializer.toString();
        }
    }
}

