/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity;

import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.This;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@Extension
public class EntityInfoProvider {
    public static boolean shouldSit(@This Entity entity) {
        Entity vehicle;
        return entity.isPassenger() && (vehicle = entity.getVehicle()) != null;
    }

    public static float getHeadPatch(@This Entity entity, float partialTick) {
        return -OpenMath.lerp(partialTick, entity.xRotO, entity.getXRot());
    }

    public static float getHeadYaw(@This Entity entity, float partialTick) {
        Entity entity2;
        if (!(entity instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        float lerpBodyRot = OpenMath.rotLerp(partialTick, livingEntity.yBodyRotO, livingEntity.yBodyRot);
        float lerpHeadRot = OpenMath.rotLerp(partialTick, livingEntity.yHeadRotO, livingEntity.yHeadRot);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (livingEntity.isPassenger() && (entity2 = livingEntity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity2;
            lerpBodyRot = OpenMath.rotLerp(partialTick, livingEntity2.yBodyRotO, livingEntity2.yBodyRot);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = OpenMath.clamp(OpenMath.wrapDegrees(netHeadYaw), -85.0f, 85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        return -OpenMath.clamp(OpenMath.wrapDegrees(netHeadYaw), -85.0f, 85.0f);
    }
}

