/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IBlockEntityCapability;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IEntityCapability;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeEventBus;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistries;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeStorage;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class AbstractForgeCapabilityManager {
    public static <T> IRegistryHolder<IEntityCapability<T>> registerEntity(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory) {
        if (type == SkinWardrobe.class) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractForgeCapabilityManager.createWardrobeCapability(registryName, (Function)Objects.unsafeCast(factory)));
        }
        throw new AssertionError();
    }

    public static <T> IRegistryHolder<IBlockEntityCapability<T>> registerBlockEntity(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory) {
        if (registryName.equals(ModConstants.key("item"))) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractForgeCapabilityManager.createSidedCapability(registryName, Capabilities.ItemHandler.BLOCK));
        }
        if (registryName.equals(ModConstants.key("fluid"))) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractForgeCapabilityManager.createSidedCapability(registryName, Capabilities.FluidHandler.BLOCK));
        }
        if (registryName.equals(ModConstants.key("energy"))) {
            return (IRegistryHolder)Objects.unsafeCast(AbstractForgeCapabilityManager.createSidedCapability(registryName, Capabilities.EnergyStorage.BLOCK));
        }
        throw new AssertionError();
    }

    private static IRegistryHolder<IEntityCapability<SkinWardrobe>> createWardrobeCapability(IResourceLocation registryName, Function<Entity, Optional<SkinWardrobe>> provider) {
        EntityCapability capability = EntityCapability.createVoid((ResourceLocation)registryName.toLocation(), SkinWardrobe.class);
        IEntityCapability capability1 = entity -> Optional.ofNullable((SkinWardrobe)entity.getCapability(capability));
        return new HolderProxy<SkinWardrobe>(registryName, SkinWardrobe.class, provider, capability1, () -> capability);
    }

    private static <T> IRegistryHolder<IBlockEntityCapability<T>> createSidedCapability(IResourceLocation registryName, BlockCapability<T, Direction> capability) {
        IBlockEntityCapability<Object> capability1 = (arg_0, arg_1, arg_2, arg_3, arg_4) -> capability.getCapability(arg_0, arg_1, arg_2, arg_3, arg_4);
        AbstractForgeEventBus.observer(RegisterCapabilitiesEvent.class, event -> event.registerBlockEntity(capability, (BlockEntityType)((IBlockEntityType)ModBlockEntityTypes.SKINNABLE.get()).get(), (entity, context) -> entity.getCapability(capability1, (Direction)context)));
        return TypedRegistry.Entry.castValue(registryName, capability1);
    }

    private static class HolderProxy<T extends IDataSerializable.Mutable>
    implements IRegistryHolder<IEntityCapability<T>> {
        final IResourceLocation registryName;
        final Supplier<EntityCapability<T, Void>> capability;
        final Class<T> type;
        final IEntityCapability<T> capabilityType;
        final IRegistryHolder<AttachmentType<CapabilitySerializer<T>>> attachmentType;

        protected HolderProxy(IResourceLocation registryName, Class<T> type, Function<Entity, Optional<T>> factory, IEntityCapability<T> capabilityType, Supplier<EntityCapability<T, Void>> capability) {
            this.type = type;
            this.attachmentType = CapabilitySerializer.register(registryName, factory);
            this.capability = capability;
            this.capabilityType = capabilityType;
            this.registryName = registryName;
            this.register();
        }

        public void register() {
            AbstractForgeEventBus.observer(RegisterCapabilitiesEvent.class, event -> {
                for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
                    event.registerEntity(this.capability.get(), entityType, (entity, context) -> ((CapabilitySerializer)entity.getData(this.attachmentType)).getValue());
                }
            });
        }

        @Override
        public IEntityCapability<T> get() {
            return this.capabilityType;
        }

        @Override
        public IResourceLocation registryName() {
            return this.registryName;
        }
    }

    private static class CapabilitySerializer<T extends IDataSerializable.Mutable>
    implements INBTSerializable<CompoundTag> {
        protected static final ArrayList<String> DATA_KEYS = new ArrayList();
        protected final T value;
        protected final WeakReference<Entity> entity;

        protected CapabilitySerializer(Entity entity, T value) {
            this.value = value;
            this.entity = new WeakReference<Entity>(entity);
        }

        public static <T extends IDataSerializable.Mutable> IRegistryHolder<AttachmentType<CapabilitySerializer<T>>> register(IResourceLocation registryName, Function<Entity, Optional<T>> factory) {
            DATA_KEYS.add(registryName.toString());
            Function<IAttachmentHolder, CapabilitySerializer> transformer = holder -> new CapabilitySerializer<IDataSerializable.Mutable>((Entity)holder, ((Optional)factory.apply((Entity)holder)).orElse(null));
            return AbstractForgeRegistries.ATTACHMENT_TYPES.register(registryName.path(), () -> AttachmentType.serializable((Function)transformer).build());
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            if (this.value != null) {
                CompoundTag tag = new CompoundTag();
                this.value.serialize(SkinWardrobeStorage.encoder((Entity)this.entity.get(), tag));
                return tag;
            }
            return null;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            if (this.value != null) {
                this.value.deserialize(SkinWardrobeStorage.decoder((Entity)this.entity.get(), tag));
            }
        }

        public T getValue() {
            return this.value;
        }
    }
}

