/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.key.IKeyModifier;
import moe.plushie.armourers_workshop.api.event.EventBus;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.event.client.RegisterKeyMappingsEvent;
import moe.plushie.armourers_workshop.utils.OpenKeyModifier;
import net.minecraft.client.KeyMapping;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractForgeKeyMapping
extends KeyMapping {
    private static final HashMap<InputConstants.Key, ArrayList<KeyMapping>> MAPPINGS = new HashMap();
    private static final Map<IKeyModifier, KeyModifier> MODIFIERS1 = Collections.immutableMap(builder -> {
        builder.put((Object)OpenKeyModifier.CONTROL, (Object)KeyModifier.CONTROL);
        builder.put((Object)OpenKeyModifier.SHIFT, (Object)KeyModifier.SHIFT);
        builder.put((Object)OpenKeyModifier.ALT, (Object)KeyModifier.ALT);
        builder.put((Object)OpenKeyModifier.NONE, (Object)KeyModifier.NONE);
    });
    private static final Map<KeyModifier, IKeyModifier> MODIFIERS2 = Collections.immutableMap(builder -> {
        builder.put((Object)KeyModifier.CONTROL, (Object)OpenKeyModifier.CONTROL);
        builder.put((Object)KeyModifier.SHIFT, (Object)OpenKeyModifier.SHIFT);
        builder.put((Object)KeyModifier.ALT, (Object)OpenKeyModifier.ALT);
        builder.put((Object)KeyModifier.NONE, (Object)OpenKeyModifier.NONE);
    });

    public AbstractForgeKeyMapping(String description, IKeyModifier keyModifier, InputConstants.Key keyCode, String category) {
        super(description, (IKeyConflictContext)KeyConflictContext.IN_GAME, MODIFIERS1.getOrDefault(keyModifier, KeyModifier.NONE), keyCode, category);
        AbstractForgeKeyMapping.bind(keyCode, this);
    }

    public static void register(String key, KeyMapping keyMapping) {
        EventBus.register(RegisterKeyMappingsEvent.class, (E event) -> event.register(keyMapping));
    }

    private static void bind(InputConstants.Key keyCode, KeyMapping keyMapping) {
        MAPPINGS.computeIfAbsent(keyCode, k -> new ArrayList()).add(keyMapping);
    }

    private static void unbind(InputConstants.Key keyCode, KeyMapping keyMapping) {
        ArrayList<KeyMapping> mappings = MAPPINGS.get(keyCode);
        if (mappings != null) {
            mappings.remove(keyMapping);
        }
    }

    @Nullable
    public static List<KeyMapping> findKeysByCode(InputConstants.Key keyCode) {
        ArrayList<KeyMapping> mappings = MAPPINGS.get(keyCode);
        if (mappings != null) {
            return mappings.stream().filter(binding -> binding.isActiveAndMatches(keyCode)).toList();
        }
        return null;
    }

    public boolean consumeClick() {
        return super.consumeClick();
    }

    public IKeyModifier getOpenKeyModifier() {
        return MODIFIERS2.getOrDefault(this.getKeyModifier(), OpenKeyModifier.NONE);
    }

    public void setKeyModifierAndCode(KeyModifier keyModifier, InputConstants.Key keyCode) {
        AbstractForgeKeyMapping.unbind(this.getKey(), this);
        super.setKeyModifierAndCode(keyModifier, keyCode);
        AbstractForgeKeyMapping.bind(this.getKey(), this);
    }
}

