/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.permission.IPermissionContext;
import moe.plushie.armourers_workshop.api.permission.IPermissionNode;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeEventBus;
import moe.plushie.armourers_workshop.core.permission.BlockPermissionContext;
import moe.plushie.armourers_workshop.core.permission.PlayerPermissionContext;
import moe.plushie.armourers_workshop.core.permission.TargetPermissionContext;
import moe.plushie.armourers_workshop.init.platform.forge.builder.PermissionNodeBuilderImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;

public abstract class AbstractForgePermissionManager {
    private static final ArrayList<PermissionNode<?>> PENDING = AbstractForgePermissionManager.makeRegisterQueue();
    private static final PermissionDynamicContextKey<Entity> TARGET = new PermissionDynamicContextKey(Entity.class, "target", Object::toString);
    private static final PermissionDynamicContextKey<Player> PLAYER = new PermissionDynamicContextKey(Player.class, "player", Object::toString);
    private static final PermissionDynamicContextKey<BlockPos> BLOCK_POS = new PermissionDynamicContextKey(BlockPos.class, "block_pos", Vec3i::toShortString);
    private static final PermissionDynamicContextKey<BlockState> BLOCK_STATE = new PermissionDynamicContextKey(BlockState.class, "block_state", Object::toString);
    private static final PermissionDynamicContextKey<Direction> FACING = new PermissionDynamicContextKey(Direction.class, "facing", Direction::getSerializedName);

    public static IPermissionNode makeNode(IResourceLocation registryName, int level) {
        final PermissionNode node = new PermissionNode(registryName.toLocation(), PermissionTypes.BOOLEAN, (player, uuid, contexts) -> true, new PermissionDynamicContextKey[]{TARGET, PLAYER, BLOCK_POS, BLOCK_STATE, FACING});
        PermissionNodeBuilderImpl.NodeImpl nodeImpl = new PermissionNodeBuilderImpl.NodeImpl(registryName){

            @Override
            public boolean resolve(Player player, IPermissionContext context) {
                if (!AbstractForgePermissionManager.hasPermissionAPI()) {
                    return true;
                }
                if (player instanceof ServerPlayer) {
                    return (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), (PermissionNode)node, AbstractForgePermissionManager.makeContexts(context));
                }
                return super.resolve(player, context);
            }

            @Override
            public boolean resolve(GameProfile profile, IPermissionContext context) {
                if (!AbstractForgePermissionManager.hasPermissionAPI()) {
                    return true;
                }
                return (Boolean)PermissionAPI.getOfflinePermission((UUID)profile.getId(), (PermissionNode)node, AbstractForgePermissionManager.makeContexts(context));
            }
        };
        node.setInformation(nodeImpl.name(), nodeImpl.description());
        PENDING.add(node);
        return nodeImpl;
    }

    private static PermissionDynamicContext<?>[] makeContexts(IPermissionContext context) {
        ArrayList<PermissionDynamicContext> contexts = new ArrayList<PermissionDynamicContext>();
        if (context instanceof PlayerPermissionContext) {
            PlayerPermissionContext player = (PlayerPermissionContext)context;
            if (player.player != null) {
                contexts.add(PLAYER.createContext((Object)player.player));
            }
        }
        if (context instanceof TargetPermissionContext) {
            TargetPermissionContext target = (TargetPermissionContext)context;
            if (target.target != null) {
                contexts.add(TARGET.createContext((Object)target.target));
            }
        }
        if (context instanceof BlockPermissionContext) {
            BlockPermissionContext block = (BlockPermissionContext)context;
            if (block.blockPos != null) {
                contexts.add(BLOCK_POS.createContext((Object)block.blockPos));
            }
            if (block.blockState != null) {
                contexts.add(BLOCK_STATE.createContext((Object)block.blockState));
            }
            if (block.facing != null) {
                contexts.add(FACING.createContext((Object)block.facing));
            }
        }
        return contexts.toArray(new PermissionDynamicContext[0]);
    }

    private static boolean hasPermissionAPI() {
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    private static ArrayList<PermissionNode<?>> makeRegisterQueue() {
        AbstractForgeEventBus.observer(PermissionGatherEvent.Nodes.class, event -> event.addNodes(PENDING));
        return new ArrayList();
    }
}

