/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class AbstractForgeRegistryManager
extends AbstractRegistryManager {
    public static final AbstractForgeRegistryManager INSTANCE = new AbstractForgeRegistryManager();

    @Override
    protected ResourceLocation getItemKey0(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @Override
    protected ResourceLocation getBlockKey0(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    @Override
    protected Predicate<ItemStack> getItemTag0(ResourceLocation key) {
        TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key);
        return itemStack -> itemStack.is(tag);
    }

    @Override
    protected Predicate<BlockState> getBlockTag0(ResourceLocation key) {
        TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)key);
        return blockState -> blockState.is(tag);
    }

    @Override
    protected Predicate<AbstractRegistryManager.Biome> getBiomeTag0(ResourceLocation key) {
        TagKey tag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)key);
        return info -> info.getLevel().getBiome(info.getBlockPos()).is(tag);
    }

    @Override
    protected Function<ItemStack, Integer> getEnchantment0(ResourceLocation key) {
        Holder enchantment = this.getHolder0(Registries.ENCHANTMENT, key);
        if (enchantment != null) {
            return itemStack -> EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)itemStack);
        }
        return null;
    }

    @Override
    protected Function<LivingEntity, MobEffectInstance> getEffect0(ResourceLocation key) {
        Holder effect = this.getHolder0(Registries.MOB_EFFECT, key);
        if (effect != null) {
            return entity -> entity.getEffect(effect);
        }
        return null;
    }

    @Override
    protected Function<LivingEntity, Double> getAttribute0(ResourceLocation key) {
        Holder attribute = this.getHolder0(Registries.ATTRIBUTE, key);
        if (attribute != null) {
            return entity -> entity.getAttributeValue(attribute);
        }
        return null;
    }

    protected <E> Holder<E> getHolder0(ResourceKey<? extends Registry<? extends E>> registryKey, ResourceLocation rl) {
        RegistryAccess registryAccess = this.findRegistryAccess();
        if (registryAccess != null) {
            Optional registry = registryAccess.registry(registryKey);
            return registry.flatMap(it -> it.getHolder(rl)).orElse(null);
        }
        return null;
    }

    protected RegistryAccess findRegistryAccess() {
        MinecraftServer server = EnvironmentManager.getServer();
        if (server != null) {
            return server.registryAccess();
        }
        Optional<Object> client = EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> {
            ClientPacketListener connection = EnvironmentManager.getClient().getConnection();
            if (connection != null) {
                return connection.registryAccess();
            }
            return null;
        });
        return client.orElse(null);
    }
}

