/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge.mixin;

import moe.plushie.armourers_workshop.api.common.IBlockEntityHandler;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntity;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeBlockEntity;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={AbstractBlockEntity.class})
public abstract class ForgeBlockEntityHandlerMixin
implements AbstractForgeBlockEntity {
    @Override
    public AABB getRenderBoundingBox() {
        AbstractBlockEntity blockEntity = (AbstractBlockEntity)AbstractBlockEntity.class.cast(this);
        AABB result = blockEntity.getVisibleBox(blockEntity.getBlockState());
        if (result != null) {
            return result;
        }
        return AbstractForgeBlockEntity.super.getRenderBoundingBox();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        ForgeBlockEntityHandlerMixin forgeBlockEntityHandlerMixin = this;
        if (forgeBlockEntityHandlerMixin instanceof IBlockEntityHandler) {
            IBlockEntityHandler handler = (IBlockEntityHandler)((Object)forgeBlockEntityHandlerMixin);
            AbstractBlockEntity blockEntity = (AbstractBlockEntity)AbstractBlockEntity.class.cast(this);
            handler.handleUpdatePacket(blockEntity.getBlockState(), new TagSerializer(pkt.getTag(), provider));
        }
    }
}

