/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.capability;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.EntityCollisionContainer;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.NonNullItemList;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class SkinWardrobeStorage {
    public static IDataSerializer decoder(Entity entity, CompoundTag inputTag) {
        return new TagSerializer(inputTag, entity);
    }

    public static IDataSerializer encoder(Entity entity, CompoundTag outputTag) {
        return new TagSerializer(outputTag, entity);
    }

    public static void saveDataFixer(SkinWardrobe wardrobe, IDataSerializer serializer) {
        serializer.write(CodingKeys.VERSION, (byte)1);
    }

    public static void loadDataFixer(SkinWardrobe wardrobe, IDataSerializer serializer) {
        Byte version = serializer.read(CodingKeys.VERSION);
        if (version.compareTo((byte)0) <= 0) {
            Container inventory = wardrobe.inventory();
            SkinWardrobeStorage.moveSlots(inventory, 67, SkinSlotType.DYE.index(), 16, "align dye slots storage");
            SkinWardrobeStorage.moveSlots(inventory, 57, SkinSlotType.OUTFIT.index(), 10, "align outfit slots storage");
        }
    }

    public static void saveInventoryItems(Container inventory, IDataSerializer serializer) {
        NonNullItemList itemStacks = new NonNullItemList(inventory.getContainerSize());
        for (int i = 0; i < itemStacks.size(); ++i) {
            itemStacks.set(i, inventory.getItem(i));
        }
        itemStacks.serialize(serializer);
    }

    public static void loadInventoryItems(Container inventory, IDataSerializer serializer) {
        NonNullItemList itemStacks = new NonNullItemList(inventory.getContainerSize());
        itemStacks.deserialize(serializer);
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack oldItemStack;
            ItemStack newItemStack = (ItemStack)itemStacks.get(i);
            if (Objects.equals(newItemStack, oldItemStack = inventory.getItem(i))) continue;
            inventory.setItem(i, newItemStack);
        }
    }

    public static void saveBoundingBox(EntityCollisionContainer boundingBox, IDataSerializer serializer) {
        boundingBox.serialize(serializer);
    }

    public static void loadBoundingBox(EntityCollisionContainer boundingBox, SkinWardrobe wardrobe, IDataSerializer serializer) {
        boundingBox.deserialize(serializer);
    }

    public static void saveFlags(BitSet flags, IDataSerializer serializer) {
        int value = 0;
        for (int i = 0; i < 32; ++i) {
            if (!flags.get(i)) continue;
            value |= 1 << i;
        }
        if (value != 0) {
            serializer.write(CodingKeys.VISIBILITY, value);
        }
    }

    public static void loadFlags(BitSet flags, IDataSerializer serializer) {
        Integer value = serializer.read(CodingKeys.VISIBILITY);
        flags.clear();
        for (int i = 0; i < 32; ++i) {
            int mask = 1 << i;
            if ((value & mask) == 0) continue;
            flags.set(i);
        }
    }

    public static void saveSkinSlots(HashMap<SkinSlotType, Integer> slots, IDataSerializer serializer) {
        if (slots.isEmpty()) {
            return;
        }
        ArrayList value = new ArrayList();
        slots.forEach((slotType, count) -> {
            int index = slotType.id() & 0xFF;
            int encoded = index << 8 | count & 0xFF;
            value.add((short)encoded);
        });
        if (!value.isEmpty()) {
            serializer.write(CodingKeys.SLOTS, value);
        }
    }

    public static void loadSkinSlots(HashMap<SkinSlotType, Integer> slots, IDataSerializer serializer) {
        List<Short> value = serializer.read(CodingKeys.SLOTS);
        for (Short encoded : value) {
            SkinSlotType slotType = SkinSlotType.byId(encoded >> 8 & 0xFF);
            if (slotType == null) continue;
            slots.put(slotType, encoded & 0xFF);
        }
    }

    private static void moveSlots(Container inventory, int src, int dest, int size, String reason) {
        int changes = 0;
        for (int i = size - 1; i >= 0; --i) {
            ItemStack itemStack = inventory.getItem(src + i);
            if (itemStack.isEmpty()) continue;
            inventory.setItem(src + i, ItemStack.EMPTY);
            inventory.setItem(dest + i, itemStack);
            ++changes;
        }
        if (changes != 0) {
            ModLog.info("move {} items from {} - {}, to {} - {}, reason: {}", changes, src, src + size, dest, dest + size, reason);
        }
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<Byte> VERSION = IDataSerializerKey.create("DataVersion", IDataCodec.BYTE, (byte)0);
        public static final IDataSerializerKey<Integer> VISIBILITY = IDataSerializerKey.create("Visibility", IDataCodec.INT, 0);
        public static final IDataSerializerKey<List<Short>> SLOTS = IDataSerializerKey.create("Slots", IDataCodec.SHORT.listOf(), Collections.emptyList());

        private CodingKeys() {
        }
    }
}

