/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.client.animation.AnimationContext;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.animation.AnimationPlayState;
import moe.plushie.armourers_workshop.core.client.animation.bind.ClientExecutionContextImpl;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.BlockEntityAnimationState;
import moe.plushie.armourers_workshop.core.data.EntityAnimationState;
import moe.plushie.armourers_workshop.core.data.action.EntityAction;
import moe.plushie.armourers_workshop.core.data.action.EntityActionSet;
import moe.plushie.armourers_workshop.core.data.action.EntityActionTarget;
import moe.plushie.armourers_workshop.core.data.action.EntityActions;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class AnimationManager {
    public static final AnimationManager NONE = new AnimationManager(null);
    private final HashMap<BakedSkin, Entry> allEntries = new HashMap();
    private final HashMap<BakedSkin, Entry> activeEntries = new HashMap();
    private final ArrayList<Entry> triggerableEntries = new ArrayList();
    private final ArrayList<Pair<AnimationPlayState, Runnable>> removeOnCompletion = new ArrayList();
    private final HashMap<String, PlayAction> lastActions = new HashMap();
    private EntityActionSet lastAnimationState;
    private double lastAnimationTicks = 0.0;
    private final ClientExecutionContextImpl executionContext;

    public AnimationManager(Object entity) {
        this.executionContext = new ClientExecutionContextImpl(entity);
    }

    public static AnimationManager of(Entity entity) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null) {
            return renderData.animationManager();
        }
        return null;
    }

    public static AnimationManager of(BlockEntity blockEntity) {
        BlockEntityRenderData renderData = BlockEntityRenderData.of(blockEntity);
        if (renderData != null) {
            return renderData.animationManager();
        }
        return null;
    }

    public void load(Map<SkinDescriptor, BakedSkin> skins) {
        HashMap<BakedSkin, Entry> expiredEntries = new HashMap<BakedSkin, Entry>(this.allEntries);
        skins.forEach((key, skin) -> {
            expiredEntries.remove(skin);
            this.allEntries.computeIfAbsent((BakedSkin)skin, x$0 -> new Entry((BakedSkin)x$0));
        });
        expiredEntries.forEach((key, entry) -> {
            this.allEntries.remove(key);
            entry.stop();
        });
        this.rebuildTriggerableEntities();
        this.setChanged();
    }

    public void active(Map<SkinDescriptor, BakedSkin> skins) {
        HashMap<BakedSkin, Entry> expiredEntries = new HashMap<BakedSkin, Entry>(this.activeEntries);
        skins.forEach((key, skin) -> {
            Entry entry = (Entry)expiredEntries.remove(skin);
            if (entry != null) {
                return;
            }
            entry = this.allEntries.get(skin);
            if (entry == null) {
                return;
            }
            this.activeEntries.put((BakedSkin)skin, entry);
            this.resumeState(entry);
        });
        expiredEntries.forEach((key, entry) -> {
            entry.animationControllers().forEach(it -> this.lastActions.remove(it.name()));
            this.activeEntries.remove(key);
            entry.stop();
        });
    }

    public void tick(Object source, double animationTime) {
        EntityActionSet animationState;
        if (!this.removeOnCompletion.isEmpty()) {
            Iterator<Pair<AnimationPlayState, Runnable>> iterator = this.removeOnCompletion.iterator();
            while (iterator.hasNext()) {
                Pair<AnimationPlayState, Runnable> entry2 = iterator.next();
                AnimationPlayState state = (AnimationPlayState)entry2.getKey();
                state.tick(animationTime);
                if (!state.isCompleted()) continue;
                iterator.remove();
                ((Runnable)entry2.getValue()).run();
            }
        }
        if (!this.triggerableEntries.isEmpty() && (animationState = this.getAnimationState(source)) != null && !animationState.equals(this.lastAnimationState)) {
            if (ModConfig.Client.enableAnimationDebug) {
                ModLog.debug("{} action did change: {}", source, animationState);
            }
            this.triggerableEntries.forEach(entry -> entry.autoplay(animationState, animationTime));
            this.lastAnimationState = animationState.copy();
        }
        this.lastAnimationTicks = animationTime;
    }

    public void play(String name, double atTime, CompoundTag tag) {
        this.lastActions.put(name, new PlayAction(name, atTime, tag));
        for (Entry entry : this.activeEntries.values()) {
            for (AnimationController animationController : entry.animationControllers()) {
                if (!name.equals(animationController.name())) continue;
                entry.play(animationController, atTime, tag);
            }
        }
    }

    public void stop(String name) {
        if (name.isEmpty()) {
            this.lastActions.clear();
        } else {
            this.lastActions.remove(name);
        }
        for (Entry entry : this.activeEntries.values()) {
            for (AnimationController animationController : entry.animationControllers()) {
                if (!name.isEmpty() && !name.equals(animationController.name())) continue;
                entry.stop(animationController);
            }
        }
    }

    public void map(String from, String to) {
        this.allEntries.forEach((skin, entry) -> entry.map(from, to));
        this.rebuildTriggerableEntities();
        this.setChanged();
    }

    @Nullable
    public AnimationContext getAnimationContext(BakedSkin skin) {
        return this.allEntries.get(skin);
    }

    @Nullable
    private EntityActionSet getAnimationState(Object source) {
        Entity entity;
        EntityActionSet animationState;
        if (source instanceof Entity && (animationState = EntityAnimationState.of(entity = (Entity)source)) != null) {
            ((EntityAnimationState)animationState).tick(entity);
            return animationState;
        }
        if (source instanceof BlockEntity && (animationState = BlockEntityAnimationState.of((BlockEntity)(entity = (BlockEntity)source))) != null) {
            ((BlockEntityAnimationState)animationState).tick((BlockEntity)entity);
            return animationState;
        }
        return null;
    }

    private void setChanged() {
        this.lastAnimationState = null;
    }

    private void resumeState(Entry entry) {
        entry.autoplay();
        this.lastActions.forEach((name, action) -> {
            for (AnimationController animationController : entry.animationControllers()) {
                if (!name.equals(animationController.name())) continue;
                action.resume(entry, animationController);
            }
        });
    }

    private void rebuildTriggerableEntities() {
        this.triggerableEntries.clear();
        this.triggerableEntries.addAll(Collections.filter(this.allEntries.values(), Entry::hasTriggerableAnimation));
    }

    protected class PlayAction {
        private final double time;
        private final String name;
        private final CompoundTag tag;

        public PlayAction(String name, double time, CompoundTag tag) {
            this.name = name;
            this.time = time;
            this.tag = tag;
        }

        public void resume(Entry entry, AnimationController animationController) {
            double endTime;
            if (animationController.loop() == SkinAnimationLoop.NONE && (endTime = this.time + animationController.duration()) < AnimationManager.this.lastAnimationTicks) {
                return;
            }
            if (ModConfig.Client.enableAnimationDebug) {
                ModLog.debug("resume animation {}", this.name);
            }
            entry.play(animationController, this.time, this.tag);
        }
    }

    protected class Entry
    extends AnimationContext {
        protected final List<TriggerableController> triggerableControllers;
        protected final HashMap<String, String> actionToName;
        protected TriggerableController playing;
        protected boolean isLocking;
        protected boolean isFirstTransitionAnimation;

        public Entry(BakedSkin skin) {
            super(AnimationManager.this.executionContext, skin.animationControllers());
            this.triggerableControllers = new ArrayList<TriggerableController>();
            this.actionToName = new HashMap();
            this.isFirstTransitionAnimation = true;
            this.rebuildTriggerableControllers();
        }

        public void map(String action, String newName) {
            if (action.equals(newName) || newName.isEmpty()) {
                this.actionToName.remove(action);
            } else {
                this.actionToName.put(action, newName);
            }
            this.rebuildTriggerableControllers();
        }

        public void autoplay() {
            this.animationControllers.stream().filter(AnimationController::isParallel).forEach(it -> this.startPlay((AnimationController)it, TickUtils.animationTicks(), 1.0, 0));
        }

        public void autoplay(EntityActionSet actionSet, double time) {
            if (this.isLocking && this.playing != null) {
                return;
            }
            TriggerableController newValue = this.findTriggerableController(actionSet);
            if (newValue != null && newValue != this.playing) {
                this.play(newValue, this.playing, time, 1.0, newValue.playCount(), false);
            }
        }

        public void play(AnimationController animationController, double time, CompoundTag tag) {
            Properties properties = new Properties(new TagSerializer(tag));
            if (animationController.isParallel()) {
                this.startPlay(animationController, time, properties.speed, properties.playCount);
                return;
            }
            TriggerableController newValue = this.findTriggerableController(animationController);
            if (newValue != null && newValue != this.playing) {
                this.play(newValue, this.playing, time, properties.speed, properties.playCount, properties.needsLock);
            }
        }

        public void stop(AnimationController animationController) {
            AnimationPlayState playState = this.getPlayState(animationController);
            if (playState == null) {
                return;
            }
            if (animationController.isParallel()) {
                this.stopPlayIfNeeded(animationController);
                return;
            }
            TriggerableController oldValue = this.playing;
            if (oldValue == null || oldValue.animationController != animationController) {
                return;
            }
            this.playing = null;
            this.isLocking = false;
            this.stopPlayIfNeeded(animationController);
            AnimationManager.this.setChanged();
        }

        public void stop() {
            this.animationControllers.forEach(this::stop);
        }

        public boolean hasTriggerableAnimation() {
            return !this.triggerableControllers.isEmpty();
        }

        private void play(TriggerableController newValue, @Nullable TriggerableController oldValue, double time, double speed, int playCount, boolean needLock) {
            AnimationController toAnimationController = newValue.animationController;
            AnimationController fromAnimationController = Objects.flatMap(oldValue, it -> it.animationController);
            if (fromAnimationController != null) {
                this.stopPlayIfNeeded(fromAnimationController);
            }
            this.startPlay(toAnimationController, time, speed, playCount);
            this.isLocking = needLock;
            this.playing = newValue;
            double duration = newValue.transitionDuration();
            this.applyTransiting(fromAnimationController, toAnimationController, time, speed, duration);
        }

        private void startPlay(AnimationController animationController, double time, double speed, int playCount) {
            this.stopPlayIfNeeded(animationController);
            AnimationPlayState newPlayState = AnimationPlayState.create(time, playCount, speed, animationController);
            this.addPlayState(animationController, newPlayState);
            if (ModConfig.Client.enableAnimationDebug) {
                ModLog.debug("start play {}", animationController);
            }
            if (newPlayState.loopCount() > 0) {
                AnimationManager.this.removeOnCompletion.add((Pair<AnimationPlayState, Runnable>)Pair.of((Object)newPlayState, () -> this.stop(animationController)));
            }
        }

        private void stopPlayIfNeeded(AnimationController animationController) {
            AnimationPlayState oldPlayState = this.removePlayState(animationController);
            if (oldPlayState != null) {
                if (ModConfig.Client.enableAnimationDebug) {
                    ModLog.debug("stop play {}", animationController);
                }
                oldPlayState.reset();
                AnimationManager.this.removeOnCompletion.removeIf(it -> it.getLeft() == oldPlayState);
            }
        }

        private void applyTransiting(AnimationController fromAnimationController, AnimationController toAnimationController, double time, double speed, double duration) {
            if (this.isFirstTransitionAnimation) {
                this.isFirstTransitionAnimation = false;
                return;
            }
            AnimationPlayState playState = this.getPlayState(toAnimationController);
            if (playState != null) {
                playState.setTime(playState.time() + duration);
            }
            this.addAnimation(fromAnimationController, toAnimationController, time, speed, duration);
        }

        private String resolveMappingName(String name) {
            for (Map.Entry<String, String> entry : this.actionToName.entrySet()) {
                if (entry.getValue().equals(name)) {
                    return entry.getKey();
                }
                if (!entry.getKey().equals(name)) continue;
                return "redirected:" + name;
            }
            return name;
        }

        private TriggerableController findTriggerableController(EntityActionSet actionSet) {
            for (TriggerableController entry : this.triggerableControllers) {
                if (!entry.isIdle && !entry.test(actionSet)) continue;
                return entry;
            }
            return null;
        }

        private TriggerableController findTriggerableController(AnimationController animationController) {
            for (TriggerableController entry : this.triggerableControllers) {
                if (entry.animationController != animationController) continue;
                return entry;
            }
            return null;
        }

        private void rebuildTriggerableControllers() {
            ArrayList<TriggerableController> newValues = new ArrayList<TriggerableController>();
            for (AnimationController animationController : this.animationControllers) {
                if (animationController.isParallel()) continue;
                String name = this.resolveMappingName(animationController.name());
                TriggerableController controller = new TriggerableController(name, animationController);
                newValues.add(controller);
            }
            newValues.sort(Comparator.comparingDouble(TriggerableController::priority).reversed());
            this.triggerableControllers.clear();
            this.triggerableControllers.addAll(newValues);
            if (this.playing == null) {
                return;
            }
            this.playing = this.findTriggerableController(this.playing.animationController);
        }
    }

    protected static class TriggerableController {
        private final String name;
        private final EntityActionTarget target;
        private final AnimationController animationController;
        private final boolean isIdle;

        public TriggerableController(String name, AnimationController animationController) {
            this.name = name;
            this.target = EntityActions.by(name);
            this.animationController = animationController;
            this.isIdle = this.target.actions().contains((Object)EntityAction.IDLE);
        }

        public boolean test(EntityActionSet actionSet) {
            int hit = 0;
            for (EntityAction action : this.target.actions()) {
                if (!actionSet.contains(action)) {
                    return false;
                }
                ++hit;
            }
            return hit != 0;
        }

        public String name() {
            return this.name;
        }

        public double priority() {
            return this.target.priority();
        }

        public double transitionDuration() {
            return this.target.transitionDuration();
        }

        public int playCount() {
            return this.target.playCount();
        }

        public String toString() {
            return this.animationController.toString();
        }
    }

    protected static class Properties
    implements IDataSerializable.Immutable {
        public static final IDataSerializerKey<Float> SPEED = IDataSerializerKey.create("speed", IDataCodec.FLOAT, Float.valueOf(1.0f));
        public static final IDataSerializerKey<Integer> REPEAT = IDataSerializerKey.create("repeat", IDataCodec.INT, 0);
        public static final IDataSerializerKey<Boolean> LOCK = IDataSerializerKey.create("lock", IDataCodec.BOOL, true);
        public static final IDataCodec<Properties> CODEC = IDataCodec.COMPOUND_TAG.serializer(Properties::new);
        private final float speed;
        private final int playCount;
        private final boolean needsLock;

        public Properties(IDataSerializer serializer) {
            this.speed = OpenMath.clamp(serializer.read(SPEED).floatValue(), 1.0E-4f, 1000.0f);
            this.playCount = OpenMath.clamp(serializer.read(REPEAT), -1, 1000);
            this.needsLock = serializer.read(LOCK);
        }

        @Override
        public void serialize(IDataSerializer serializer) {
            serializer.write(SPEED, Float.valueOf(this.speed));
            serializer.write(REPEAT, this.playCount);
            serializer.write(LOCK, this.needsLock);
        }
    }
}

