/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVehicleUpdater;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.Minecraft.Camera;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderMode;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentPose;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentType;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BakedAttachmentPartTransform {
    protected final int index;
    protected final SkinAttachmentType type;
    protected final Collection<BakedSkinPart> children;

    protected BakedAttachmentPartTransform(SkinAttachmentType type, int index, Collection<BakedSkinPart> children) {
        this.type = type;
        this.index = index;
        this.children = children;
    }

    public static Collection<BakedAttachmentPartTransform> create(Collection<BakedSkinPart> parts) {
        ArrayList<BakedAttachmentPartTransform> results = new ArrayList<BakedAttachmentPartTransform>();
        for (BakedSkinPart skinPart : parts) {
            BakedAttachmentPartTransform.collect(skinPart, new Stack<BakedSkinPart>(), results);
        }
        return results;
    }

    private static void collect(BakedSkinPart part, Stack<BakedSkinPart> parent, ArrayList<BakedAttachmentPartTransform> results) {
        parent.push(part);
        if (part.type() == SkinPartTypes.ADVANCED_LOCATOR) {
            results.add(BakedAttachmentPartTransform.create(part.name(), new ArrayList<BakedSkinPart>(parent)));
        }
        for (BakedSkinPart child : part.children()) {
            BakedAttachmentPartTransform.collect(child, parent, results);
        }
        parent.pop();
    }

    protected static BakedAttachmentPartTransform create(String name, Collection<BakedSkinPart> children) {
        Pair<SkinAttachmentType, Integer> pair = SkinAttachmentTypes.parse(name);
        Integer index = (Integer)pair.getValue();
        SkinAttachmentType type = (SkinAttachmentType)pair.getKey();
        if (type == SkinAttachmentTypes.RIDING) {
            return new Ridding(type, index, children);
        }
        return new BakedAttachmentPartTransform(type, index, children);
    }

    public void setup(@Nullable Entity entity, BakedArmature armature, SkinRenderContext context) {
        EntityRenderData renderData = context.renderData();
        if (renderData == null) {
            return;
        }
        float partialTicks = context.partialTicks();
        IPoseStack poseStack = context.poseStack();
        this.setup(entity, armature, partialTicks, poseStack, renderData);
    }

    protected void setup(Entity entity, BakedArmature armature, float partialTicks, IPoseStack poseStack, EntityRenderData renderData) {
        poseStack.pushPose();
        this.apply(entity, armature, partialTicks, poseStack, renderData);
        if (ModDebugger.attachmentOverride && !PlaceholderManager.isPlaceholder(entity)) {
            AbstractBufferSource tesselator = AbstractBufferSource.tesselator();
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, poseStack, tesselator);
            tesselator.endBatch();
        }
        poseStack.popPose();
    }

    protected void apply(Entity entity, BakedArmature armature, float partialTicks, IPoseStack poseStack, EntityRenderData renderData) {
        for (BakedSkinPart child : this.children) {
            IJointTransform jointTransform = armature.transformByPart(child);
            if (jointTransform != null) {
                jointTransform.apply(poseStack);
            }
            child.transform().apply(poseStack);
        }
        poseStack.scale(16.0f, 16.0f, 16.0f);
        renderData.setAttachmentPose(this.type, this.index, new SkinAttachmentPose(poseStack.last()));
    }

    private static class Ridding
    extends BakedAttachmentPartTransform {
        protected Ridding(SkinAttachmentType type, int index, Collection<BakedSkinPart> children) {
            super(type, index, children);
        }

        @Override
        protected void setup(Entity entity, BakedArmature armature, float partialTicks, IPoseStack poseStack, EntityRenderData renderData) {
            if (SkinRenderMode.inGUI()) {
                return;
            }
            OpenPoseStack poseStack1 = new OpenPoseStack();
            this.apply(entity, armature, partialTicks, poseStack1, renderData);
            AbstractVehicleUpdater.getInstance().submit(entity);
            if (ModDebugger.attachmentOverride && !PlaceholderManager.isPlaceholder(entity)) {
                AbstractBufferSource tesselator = AbstractBufferSource.tesselator();
                poseStack.pushPose();
                poseStack.multiply(poseStack1.last().pose());
                poseStack.multiply(poseStack1.last().normal());
                ShapeTesselator.vector(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, poseStack, tesselator);
                tesselator.endBatch();
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.setIdentity();
                OpenVector3f cameraPos = Camera.getCameraPosition(EnvironmentManager.getClient());
                OpenMatrix4f mat = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
                mat.rotate(OpenVector3f.YP.rotationDegrees(180.0f - entity.getViewYRot(partialTicks)));
                mat.scale(-1.0f, -1.0f, 1.0f);
                mat.scale(1.1f, 1.1f, 1.1f);
                mat.translate(0.0f, -1.501f, 0.0f);
                mat.scale(0.0625f, 0.0625f, 0.0625f);
                mat.multiply(poseStack1.last().pose());
                OpenVector3f offset = OpenVector3f.ZERO.transforming(mat);
                double d0 = OpenMath.lerp((double)partialTicks, entity.xOld, entity.getX()) + (double)offset.x() - (double)cameraPos.x();
                double d1 = OpenMath.lerp((double)partialTicks, entity.yOld, entity.getY()) + (double)offset.y() - (double)cameraPos.y();
                double d2 = OpenMath.lerp((double)partialTicks, entity.zOld, entity.getZ()) + (double)offset.z() - (double)cameraPos.z();
                poseStack.translate((float)d0, (float)d1, (float)d2);
                ShapeTesselator.vector(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, poseStack, tesselator);
                tesselator.endBatch();
                poseStack.popPose();
            }
        }
    }
}

