/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedGeometryQuads;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkinPart {
    private final int id = OpenRandomSource.nextInt(BakedSkinPart.class);
    private final SkinPart part;
    private final BakedGeometryQuads quads;
    private final SkinPartTransform transform;
    private final ColorDescriptor descriptor;
    private final ArrayList<BakedSkinPart> children = new ArrayList();
    private float renderPolygonOffset;
    private boolean shouldRender = true;
    private Function<IJointTransform, IJointTransform> jointTransformModifier;

    public BakedSkinPart(SkinPart part, SkinPartTransform transform, BakedGeometryQuads quads) {
        this.part = part;
        this.quads = quads;
        this.transform = transform;
        this.descriptor = quads.colorInfo();
        this.renderPolygonOffset = this.type().renderPolygonOffset();
    }

    public void addPart(BakedSkinPart part) {
        this.children.add(part);
    }

    public void removePart(BakedSkinPart part) {
        this.children.remove(part);
    }

    @Nullable
    public Object requirements(SkinPaintScheme scheme) {
        if (this.descriptor.isEmpty() || scheme.isEmpty()) {
            return null;
        }
        boolean needsEntityTexture = false;
        ArrayList<Object> requirements = new ArrayList<Object>();
        for (SkinPaintType paintType : this.descriptor.paintTypes()) {
            if (paintType.dyeType() != null) {
                SkinPaintColor resolvedColor = scheme.getResolvedColor(paintType);
                requirements.add(paintType.id());
                requirements.add(resolvedColor);
                if (resolvedColor != null) {
                    paintType = resolvedColor.paintType();
                }
            }
            if (paintType != SkinPaintTypes.TEXTURE) continue;
            needsEntityTexture = true;
        }
        if (needsEntityTexture && EntityTextureLoader.getInstance().getTextureModel(scheme.texture()) != null) {
            requirements.add(SkinPaintTypes.TEXTURE.id());
            requirements.add(scheme.texture());
        }
        return requirements;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        String name = this.part.name();
        if (name == null) {
            name = this.part.type().name();
        }
        return name;
    }

    public SkinPart part() {
        return this.part;
    }

    public SkinPartType type() {
        return this.part.type();
    }

    public SkinPartTransform transform() {
        return this.transform;
    }

    public ColorDescriptor colorInfo() {
        return this.quads.colorInfo();
    }

    public OpenVoxelShape renderShape() {
        return this.quads.shape();
    }

    public int markerTotal() {
        return this.part.markers().size();
    }

    public void setRenderPolygonOffset(float renderPolygonOffset) {
        this.renderPolygonOffset = renderPolygonOffset;
    }

    public float renderPolygonOffset() {
        return this.renderPolygonOffset;
    }

    public void setShouldRender(boolean shouldRender) {
        this.shouldRender = shouldRender;
    }

    public boolean isVisible() {
        return this.shouldRender;
    }

    public ArrayList<BakedSkinPart> children() {
        return this.children;
    }

    public SkinProperties properties() {
        return this.part.properties();
    }

    public void setJointTransformModifier(Function<IJointTransform, IJointTransform> jointTransformModifier) {
        this.jointTransformModifier = jointTransformModifier;
    }

    public Function<IJointTransform, IJointTransform> jointTransformModifier() {
        return this.jointTransformModifier;
    }

    public BakedGeometryQuads quads() {
        return this.quads;
    }
}

