/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeExtraSetting
extends SkinWardrobeBaseSetting {
    private final SkinWardrobe wardrobe;

    public SkinWardrobeExtraSetting(SkinWardrobe wardrobe) {
        super("wardrobe.man_extras");
        this.wardrobe = wardrobe;
        this.setup();
    }

    private void setup() {
        this.setupOptionView(0, UpdateWardrobePacket.Field.MANNEQUIN_IS_CHILD, "label.isChild");
        this.setupOptionView(1, UpdateWardrobePacket.Field.MANNEQUIN_EXTRA_RENDER, "label.isExtraRenders");
        this.setupOptionView(2, UpdateWardrobePacket.Field.MANNEQUIN_IS_FLYING, "label.isFlying");
        this.setupOptionView(3, UpdateWardrobePacket.Field.MANNEQUIN_IS_VISIBLE, "label.isVisible");
        this.setupOptionView(4, UpdateWardrobePacket.Field.MANNEQUIN_IS_GHOST, "label.noClip");
        this.setupOptionView(5, UpdateWardrobePacket.Field.MANNEQUIN_NO_GRAVITY, "label.noGravity");
    }

    private void setupOptionView(int index, UpdateWardrobePacket.Field<Boolean> option, String key) {
        UICheckBox checkBox = new UICheckBox(new CGRect(83.0f, 27 + 14 * index, 185.0f, 10.0f));
        checkBox.setTitle(this.getDisplayText(key, new Object[0]));
        checkBox.setSelected(option.getOrDefault(this.wardrobe, true));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)Objects.unsafeCast(c);
            NetworkManager.sendToServer(option.buildPacket(self.wardrobe, checkBox1.isSelected()));
        });
        this.addSubview(checkBox);
    }
}

