/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import com.apple.library.uikit.UIWindowManager;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreen;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContainerMenuScreen<M extends AbstractContainerMenu, W extends UIWindow>
extends AbstractMenuScreen<M> {
    private final W window;
    private final MenuWindow<?> menuWindow;
    private final UIWindowManager manager;

    public ContainerMenuScreen(W window, M menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.window = window;
        this.menuWindow = Objects.safeCast(window, MenuWindow.class);
        this.manager = new UIWindowManager();
        this.manager.addWindow((UIWindow)window);
        this.manager.init();
    }

    public void init() {
        CGSize screenSize = this.screenSize();
        this.manager.layout(screenSize.width, screenSize.height);
        CGRect rect = ((UIView)this.window).bounds();
        this.setContentSize(new CGSize(rect.width, rect.height));
        super.init();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
    }

    public void containerTick() {
        super.containerTick();
        this.menuWindow.screenWillTick();
    }

    public void removed() {
        super.removed();
        this.manager.deinit();
    }

    @Override
    public void render(CGGraphicsContext context, int mouseX, int mouseY, float partialTicks) {
        this.manager.tick();
        this.manager.render(context, this::_render, this::_renderBackground, this::_renderTooltip);
    }

    @Override
    public void renderLabels(CGGraphicsContext context, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.manager.mouseDown(mouseX, mouseY, button, this::_mouseClicked);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.manager.mouseUp(mouseX, mouseY, button, this::_mouseReleased);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.manager.mouseWheel(mouseX, mouseY, new CGPoint(deltaX, deltaY), this::_mouseScrolled);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.manager.mouseMoved(mouseX, mouseY, 0, this::_mouseMoved);
    }

    public boolean keyPressed(int key, int i, int j) {
        return this.manager.keyDown(key, i, j, this::_keyPressed);
    }

    public boolean keyReleased(int key, int i, int j) {
        return this.manager.keyUp(key, i, j, this::_keyReleased);
    }

    public boolean charTyped(char ch, int i) {
        return this.manager.charTyped(ch, i, 0, this::_charTyped);
    }

    public boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        return !this.manager.mouseIsInside(mouseX, mouseY, button);
    }

    public void slotClicked(Slot slot, int slotIndex, int j, ClickType clickType) {
        super.slotClicked(slot, slotIndex, j, clickType);
        this.menuWindow.menuDidChange();
    }

    @Override
    public boolean changeFocus(boolean bl) {
        return this.manager.changeKeyView(bl);
    }

    public boolean shouldRenderExtendScreen() {
        if (this.menuWindow != null) {
            return this.menuWindow.shouldRenderExtendScreen();
        }
        return false;
    }

    protected void _render(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        super.render(context, mouseX, mouseY, partialTicks);
    }

    protected void _renderTooltip(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        context.saveGraphicsState();
        context.translateCTM(0.0f, 0.0f, 400.0f);
        this.renderTooltip(context, mouseX, mouseY);
        context.restoreGraphicsState();
    }

    protected void _renderBackground(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        if (this.menuWindow != null && this.menuWindow.shouldRenderBackground()) {
            this.renderBackground(context);
        }
    }

    protected boolean _charTyped(int key, int i, int j) {
        super.charTyped((char)key, i);
        return true;
    }

    protected boolean _keyPressed(int key, int i, int j) {
        if (this.manager.isTextEditing() && !this._editingPassKey((char)key)) {
            return false;
        }
        return super.keyPressed(key, i, j);
    }

    protected boolean _keyReleased(int key, int i, int j) {
        return super.keyReleased(key, i, j);
    }

    protected boolean _mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean _mouseMoved(double mouseX, double mouseY, int button) {
        super.mouseMoved(mouseX, mouseY);
        return true;
    }

    protected boolean _mouseScrolled(double mouseX, double mouseY, CGPoint delta) {
        return super.mouseScrolled(mouseX, mouseY, (double)delta.x(), (double)delta.y());
    }

    protected boolean _mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected boolean _editingPassKey(int key) {
        return switch (key) {
            case 256 -> true;
            case 258 -> true;
            default -> false;
        };
    }
}

