/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIImage;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinComboBox
extends UIComboBox {
    protected final ArrayList<SkinType> skinTypes = new ArrayList();

    public SkinComboBox(CGRect frame) {
        super(frame);
    }

    public void reloadSkins(List<SkinType> skinTypes) {
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        for (SkinType skinType : skinTypes) {
            NSString title = new NSString((Component)TranslateUtils.Name.of(skinType));
            OpenResourceLocation rl = ArmourersWorkshop.getItemIcon(skinType);
            UIImage image = null;
            if (rl != null) {
                image = UIImage.of(rl).resizable(16.0f, 16.0f).fixed(9.0f, 9.0f).limit(16.0f, 16.0f).build();
            }
            items.add(new UIComboItem(image, title));
        }
        this.skinTypes.clear();
        this.skinTypes.addAll(skinTypes);
        this.reloadData(items);
    }

    @Nullable
    public SkinType selectedSkin() {
        int index = this.selectedIndex();
        if (index >= 0 && index < this.skinTypes.size()) {
            return this.skinTypes.get(index);
        }
        return null;
    }

    public void setSelectedSkin(@Nullable SkinType skinType) {
        super.setSelectedIndex(this.skinTypes.indexOf(skinType));
    }

    public List<SkinType> skinTypes() {
        return this.skinTypes;
    }

    @Override
    protected void updateTitleView(UIComboItem item) {
        if (item != null) {
            item = new UIComboItem(item.title, item.isEnabled);
        }
        super.updateTitleView(item);
    }

    @Override
    protected void updateEntryView(UIComboBox.Entry entry, UIComboItem item) {
        if (item != null && item.image != null) {
            UIButton button = entry.titleView;
            button.setContentEdgeInsets(UIEdgeInsets.ZERO);
            button.setTitleEdgeInsets(new UIEdgeInsets(0.0f, 2.0f, 0.0f, 0.0f));
            button.imageView().setOpaque(false);
        }
        super.updateEntryView(entry, item);
    }
}

