/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.WeakDispatcherImpl;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.init.ModTextures;
import org.jetbrains.annotations.Nullable;

public class TabView
extends UIView {
    private Entry selectedTab;
    private boolean fullscreenMode = false;
    private final ArrayList<Entry> entries = new ArrayList();
    private final WeakDispatcherImpl<Entry> dispatcher = new WeakDispatcherImpl();
    private final UIView contentView = new UIView(this.bounds());

    public TabView(CGRect frame) {
        super(frame);
        this.addSubview(this.contentView);
    }

    public <T> void addTarget(T target, BiConsumer<T, Entry> listener) {
        this.dispatcher.add(target, listener);
    }

    public <T> void removeTarget(T target) {
        this.dispatcher.remove(target);
    }

    public EntryBuilder addContentView(UIView contentView) {
        Entry view = new Entry(contentView, new CGRect(0.0f, 0.0f, 26.0f, 30.0f));
        this.addSubview(view);
        this.entries.add(view);
        view.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, TabView::switchTab);
        return new EntryBuilder(view);
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect bounds = this.bounds();
        this.contentView.setFrame(bounds);
        Entry entry = this.selectedTab;
        if (entry != null) {
            entry.contentView.setFrame(bounds);
        }
        if (this.fullscreenMode) {
            this.initFullscreenWidgets(0.0f, 0.0f, bounds.width, bounds.height);
        } else {
            this.initNormalWidgets(0.0f, 0.0f, bounds.width, bounds.height);
        }
    }

    @Override
    public boolean pointInside(CGPoint point, UIEvent event) {
        if (super.pointInside(point, event)) {
            return true;
        }
        return this.subviews().stream().anyMatch(subview -> subview.pointInside(this.convertPointToView(point, (UIView)subview), event));
    }

    @Override
    @Nullable
    public UIView hitTest(CGPoint point, UIEvent event) {
        UIView target = super.hitTest(point, event);
        if (target != this && target != this.contentView) {
            return target;
        }
        return null;
    }

    public Entry selectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(Entry selectedTab) {
        if (this.selectedTab != null) {
            this.selectedTab.contentView.removeFromSuperview();
            this.selectedTab.setSelected(false);
        }
        this.selectedTab = selectedTab;
        if (this.selectedTab != null) {
            this.selectedTab.setSelected(true);
            this.contentView.addSubview(this.selectedTab.contentView);
            this.setNeedsLayout();
            this.layoutIfNeeded();
        }
        this.dispatcher.send(selectedTab);
    }

    public Entry firstActiveTab() {
        for (Entry entry : this.entries) {
            if (entry.isHidden()) continue;
            return entry;
        }
        return null;
    }

    public Collection<Entry> tabs() {
        return this.entries;
    }

    public boolean fullscreenMode() {
        return this.fullscreenMode;
    }

    public void setFullscreenMode(boolean fullscreenMode) {
        this.fullscreenMode = fullscreenMode;
    }

    private void initNormalWidgets(float x, float y, float width, float height) {
        int ly = 5;
        int ry = 5;
        int spacing = -5;
        for (Entry tab : this.entries) {
            if (tab.isHidden()) continue;
            CGRect rect = tab.frame();
            if (tab.alignment == 0 && (float)ly + rect.height <= height) {
                tab.setFrame(new CGRect(x + -rect.width + 5.0f, y + (float)ly, rect.width, rect.height));
                tab.updateAlignment(0);
                ly = (int)((float)ly + rect.height);
                ly += spacing;
                continue;
            }
            if (!((float)ry + rect.height <= height)) continue;
            tab.setFrame(new CGRect(x + width - 4.0f, y + (float)ry, rect.width, rect.height));
            tab.updateAlignment(1);
            ry = (int)((float)ry + rect.height);
            ry += spacing;
        }
    }

    private void initFullscreenWidgets(float x, float y, float width, float height) {
        int ly = 0;
        int ry = 0;
        int spacing = -2;
        for (Entry tab : this.entries) {
            if (tab.isHidden()) continue;
            CGRect rect = tab.frame();
            if (tab.alignment == 0 && (float)ly + rect.height <= height) {
                tab.setFrame(new CGRect(x - 4.0f, y + (float)ly, rect.width, rect.height));
                tab.updateAlignment(1);
                ly = (int)((float)ly + rect.height);
                ly += spacing;
                continue;
            }
            if (!((float)ry + rect.height <= height)) continue;
            tab.setFrame(new CGRect(x + width - rect.width + 5.0f, y + (float)ry, rect.width, rect.height));
            tab.updateAlignment(0);
            ly = (int)((float)ly + rect.height);
            ly += spacing;
        }
        float mly = (height - (float)(ly - spacing)) / 2.0f;
        float mry = (height - (float)(ry - spacing)) / 2.0f;
        for (Entry tab : this.entries) {
            float dy = mry;
            if (tab.alignment1 == 1) {
                dy = mly;
            }
            tab.setFrame(tab.frame().offset(0.0f, dy));
        }
    }

    private void switchTab(UIControl control) {
        this.setSelectedTab((Entry)control);
    }

    public static class Entry
    extends UIButton {
        protected int alignment = 0;
        protected int alignment1 = -1;
        protected CGRect validBounds;
        protected final UIImageView iconView;
        protected final UIView contentView;
        protected Object target;

        public Entry(UIView contentView, CGRect frame) {
            super(frame);
            this.contentView = contentView;
            this.iconView = new UIImageView(new CGRect(0.0f, 0.0f, 16.0f, 16.0f));
            this.iconView.setUserInteractionEnabled(true);
            this.addSubview(this.iconView);
            this.setOpaque(false);
        }

        @Override
        public boolean pointInside(CGPoint point, UIEvent event) {
            return super.pointInside(point, event) && this.validBounds.contains(point);
        }

        @Override
        public void setBounds(CGRect bounds) {
            super.setBounds(bounds);
            this.validBounds = bounds.insetBy(3.0f, 0.0f, 3.0f, 0.0f);
        }

        @Nullable
        public Object target() {
            return this.target;
        }

        public UIView contentView() {
            return this.contentView;
        }

        protected void updateAlignment(int alignment) {
            if (this.alignment1 == alignment) {
                return;
            }
            CGRect rect = this.bounds();
            CGRect iconRect = this.iconView.bounds();
            float ix = (rect.width - iconRect.width) / 2.0f + (float)(alignment - 1);
            float iy = (rect.height - iconRect.height) / 2.0f;
            this.alignment1 = alignment;
            this.setBackgroundImage(this._tabButtonImages(alignment), 7);
            this.iconView.setFrame(new CGRect(ix, iy, iconRect.width, iconRect.height));
        }

        private UIImage _tabButtonImages(int alignment) {
            HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
            offsets.put(0, new CGPoint(0.0f, 1.0f));
            offsets.put(1, new CGPoint(1.0f, 1.0f));
            offsets.put(2, new CGPoint(0.0f, 0.0f));
            offsets.put(3, new CGPoint(1.0f, 0.0f));
            int width = 26;
            int height = 30;
            return UIImage.of(ModTextures.TABS).uv(width * alignment * 2, 0.0f).fixed(width, height).unzip(offsets::get).build();
        }
    }

    public static class EntryBuilder {
        public final Entry view;

        public EntryBuilder(Entry view) {
            this.view = view;
        }

        public EntryBuilder setIcon(UIImage image) {
            this.view.iconView.setImage(image.snapshot());
            this.view.iconView.setHighlightedImage(image);
            return this;
        }

        public EntryBuilder setTooltip(Object tooltip) {
            this.view.iconView.setTooltip(tooltip);
            return this;
        }

        public EntryBuilder setAlignment(int alignment) {
            this.view.alignment = alignment;
            return this;
        }

        public EntryBuilder setTarget(Object target) {
            this.view.target = target;
            return this;
        }

        public EntryBuilder setActive(boolean active) {
            this.view.setHidden(!active);
            return this;
        }
    }
}

