/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.HashMap;
import java.util.Iterator;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.event.client.AddRendererLayerEvent;
import moe.plushie.armourers_workshop.api.event.client.RemoveRendererLayerEvent;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelHolder;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerManager;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.layer.SkinWardrobeLayer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.platform.EventManager;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class EntityRendererContext {
    private int version = 0;
    private EntityType<?> entityType;
    private EntityProfile entityProfile;
    private final EntityRenderer<?> entityRenderer;
    private final HashMap<EntityModel<?>, BakedArmatureTransformer> cachedTransformers = new HashMap();

    public EntityRendererContext(EntityRenderer<?> entityRenderer) {
        this.entityRenderer = entityRenderer;
    }

    public static EntityRendererContext of(EntityRenderer<?> entityRenderer) {
        return DataContainer.of(entityRenderer, EntityRendererContext::new);
    }

    @Nullable
    public BakedArmatureTransformer createTransformer(@Nullable IModel entityModel, ArmatureTransformerManager transformerManager) {
        if (this.entityType == null || this.entityProfile == null) {
            return null;
        }
        ArmatureTransformer transformer = transformerManager.getTransformer(this.entityType, this.entityProfile, entityModel);
        if (transformer != null) {
            return BakedArmatureTransformer.create(transformer, this.entityRenderer);
        }
        return null;
    }

    @Nullable
    public BakedArmatureTransformer getTransformer(@Nullable EntityModel<?> entityModel) {
        if (this.entityType == null || this.entityProfile == null) {
            return null;
        }
        if (entityModel == null) {
            entityModel = this.entityModel();
        }
        return this.cachedTransformers.computeIfAbsent(entityModel, entityModel1 -> {
            Object model = AbstractModelHolder.ofNullable(entityModel1);
            return this.createTransformer((IModel)model, SkinRendererManager.DEFAULT);
        });
    }

    public void setEntityType(EntityType<?> entityType) {
        this.entityType = entityType;
    }

    public EntityType<?> entityType() {
        return this.entityType;
    }

    public void setEntityProfile(EntityProfile entityProfile) {
        if (Objects.equals(this.entityProfile, entityProfile)) {
            return;
        }
        EntityProfile oldValue = this.entityProfile;
        this.cachedTransformers.clear();
        this.entityProfile = entityProfile;
        ++this.version;
        EntityRenderer<?> entityRenderer = this.entityRenderer;
        if (entityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            if (oldValue == null && entityProfile != null) {
                this.addLayer(livingEntityRenderer);
            }
            if (oldValue != null && entityProfile == null) {
                this.removeLayer(livingEntityRenderer);
            }
        }
    }

    public EntityProfile entityProfile() {
        return this.entityProfile;
    }

    public EntityModel<?> entityModel() {
        EntityRenderer<?> entityRenderer = this.entityRenderer;
        if (entityRenderer instanceof RenderLayerParent) {
            RenderLayerParent modelProvider = (RenderLayerParent)entityRenderer;
            return modelProvider.getModel();
        }
        return null;
    }

    public int version() {
        return this.version;
    }

    private <T extends LivingEntity, V extends EntityModel<T>> void addLayer(LivingEntityRenderer<T, V> livingRenderer) {
        this.removeLayer(livingRenderer);
        BakedArmatureTransformer transformer = this.getTransformer(null);
        if (transformer != null) {
            SkinWardrobeLayer layer = new SkinWardrobeLayer(transformer, livingRenderer);
            livingRenderer.layers.add(0, layer);
            this.didAddLayer(layer, livingRenderer);
        }
    }

    private <T extends LivingEntity, V extends EntityModel<T>> void removeLayer(LivingEntityRenderer<T, V> livingRenderer) {
        Iterator iterator = livingRenderer.layers.iterator();
        while (iterator.hasNext()) {
            RenderLayer layer = (RenderLayer)iterator.next();
            if (!(layer instanceof SkinWardrobeLayer)) continue;
            iterator.remove();
            this.didRemoveLayer(layer, livingRenderer);
        }
    }

    private <T extends LivingEntity, V extends EntityModel<T>> void didAddLayer(final RenderLayer<T, V> layer, final LivingEntityRenderer<T, V> renderer) {
        EventManager.post(AddRendererLayerEvent.class, new AddRendererLayerEvent<T, V>(){

            @Override
            public RenderLayer<T, V> getLayer() {
                return layer;
            }

            @Override
            public LivingEntityRenderer<T, V> getRenderer() {
                return renderer;
            }
        });
    }

    private <T extends LivingEntity, V extends EntityModel<T>> void didRemoveLayer(final RenderLayer<T, V> layer, final LivingEntityRenderer<T, V> renderer) {
        EventManager.post(RemoveRendererLayerEvent.class, new RemoveRendererLayerEvent<T, V>(){

            @Override
            public RenderLayer<T, V> getLayer() {
                return layer;
            }

            @Override
            public LivingEntityRenderer<T, V> getRenderer() {
                return renderer;
            }
        });
    }
}

