/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EntitySlot {
    protected final ItemStack itemStack;
    protected final SkinDescriptor descriptor;
    protected final BakedSkin bakedSkin;
    protected final SkinPaintScheme bakedScheme;
    protected final Type slotType;
    protected final float renderPriority;
    protected final boolean useOverlayColor;

    public EntitySlot(ItemStack itemStack, SkinDescriptor descriptor, BakedSkin bakedSkin, SkinPaintScheme entityScheme, float renderPriority, Type slotType) {
        this.itemStack = itemStack;
        this.descriptor = descriptor;
        this.bakedSkin = bakedSkin;
        this.bakedScheme = EntitySlot.baking(descriptor.paintScheme(), entityScheme, slotType);
        this.renderPriority = renderPriority;
        this.slotType = slotType;
        this.useOverlayColor = bakedSkin.properties().get(SkinProperty.USE_OVERLAY_COLOR);
    }

    public static SkinPaintScheme baking(SkinPaintScheme skinScheme, SkinPaintScheme entityScheme, Type slotType) {
        if (slotType == Type.IN_HELD) {
            return skinScheme;
        }
        if (skinScheme.isEmpty()) {
            return entityScheme;
        }
        if (entityScheme.isEmpty()) {
            return skinScheme;
        }
        SkinPaintScheme bakedScheme = skinScheme.copy();
        bakedScheme.setReference(entityScheme);
        return bakedScheme;
    }

    public boolean shouldRenderInHeld(ItemStack itemStack) {
        return this.descriptor.accept(itemStack);
    }

    public float renderPriority() {
        return this.renderPriority;
    }

    public BakedSkin skin() {
        return this.bakedSkin;
    }

    public SkinType skinType() {
        return this.bakedSkin.type();
    }

    public Type slotType() {
        return this.slotType;
    }

    public SkinPaintScheme paintScheme() {
        return this.bakedScheme;
    }

    public SkinDescriptor descriptor() {
        return this.descriptor;
    }

    public ItemStack itemStack() {
        return this.itemStack;
    }

    public int getOverrideOverlay(Entity entity) {
        if (!this.useOverlayColor || !(entity instanceof LivingEntity)) {
            return OverlayTexture.NO_OVERLAY;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        int u = OverlayTexture.u((float)0.0f);
        int v = OverlayTexture.v((livingEntity.hurtTime > 0 || livingEntity.deathTime > 0 ? 1 : 0) != 0);
        return OverlayTexture.pack((int)u, (int)v);
    }

    public static enum Type {
        IN_HELD,
        IN_EQUIPMENT,
        IN_WARDROBE,
        IN_CONTAINER;

    }
}

