/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL15;

@OnlyIn(value=Dist.CLIENT)
public class VertexBufferObject {
    protected int id;
    protected int size = 0;
    protected final AtomicInteger refCount = new AtomicInteger(1);

    public VertexBufferObject() {
        this.id = GL15.glGenBuffers();
    }

    public static void unbind() {
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void bind() {
        GL15.glBindBuffer((int)34962, (int)this.id);
    }

    public void upload(ByteBuffer byteBuffer) {
        if (this.id < 0) {
            return;
        }
        this.size = byteBuffer.limit();
        this.bind();
        GL15.glBufferData((int)34962, (ByteBuffer)byteBuffer, (int)35044);
        VertexBufferObject.unbind();
    }

    void retain() {
        this.refCount.incrementAndGet();
    }

    void release() {
        int count = this.refCount.decrementAndGet();
        if (count <= 0) {
            this.close();
        }
    }

    public void close() {
        if (this.id < 0) {
            return;
        }
        GL15.glDeleteBuffers((int)this.id);
        this.id = -1;
        this.refCount.set(0);
    }
}

