/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractModelViewStack;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmaturePluginContext;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.BlockEntityRenderPatch;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinnableBlockRenderer<T extends SkinnableBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private final BakedArmature armature = new BakedArmature(Armatures.ANY);

    public SkinnableBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        BlockEntityRenderData renderData = BlockEntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        renderData.tick((BlockEntity)entity);
        List<EntitySlot> renderingTasks = renderData.allSkins();
        if (renderingTasks.isEmpty()) {
            return;
        }
        float f = 0.0625f;
        BlockState blockState = entity.getBlockState();
        OpenQuaternionf rotations = ((SkinnableBlockEntity)entity).getRenderRotations(blockState);
        BlockEntityRenderPatch<? super BlockEntity> renderPatch = renderData.renderPatch();
        MannequinEntity mannequinEntity = PlaceholderManager.MANNEQUIN.get();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.rotate(rotations);
        poseStack.scale(f, f, f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        renderPatch.activate((BlockEntity)entity, partialTicks, light, overlay, poseStack);
        DefaultArmaturePluginContext pluginContext = renderPatch.pluginContext();
        SkinRenderContext renderingContext = renderPatch.renderingContext();
        renderingContext.setOverlay(pluginContext.overlay());
        renderingContext.setLightmap(pluginContext.lightmap());
        renderingContext.setPartialTicks(pluginContext.partialTicks());
        renderingContext.setAnimationTicks(pluginContext.animationTicks());
        renderingContext.setPoseStack(poseStack);
        renderingContext.setBufferSource(bufferSource);
        renderingContext.setModelViewStack(AbstractModelViewStack.getInstance());
        for (EntitySlot entry : renderingTasks) {
            BakedSkin skin = entry.skin();
            skin.setupAnim((Entity)mannequinEntity, this.armature, renderingContext);
            SkinPaintScheme colorScheme = skin.resolve((Entity)mannequinEntity, entry.paintScheme());
            SkinRenderer.render((Entity)mannequinEntity, this.armature, skin, colorScheme, renderingContext);
            if (!ModDebugger.skinnable) continue;
            skin.blockBounds().forEach((pos, rect) -> {
                poseStack.pushPose();
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate((float)pos.x() * 16.0f, (float)pos.y() * 16.0f, (float)pos.z() * 16.0f);
                ShapeTesselator.stroke((IRectangle3f)rect, UIColor.RED, poseStack, bufferSource);
                poseStack.popPose();
            });
        }
        renderPatch.deactivate((BlockEntity)entity);
        poseStack.popPose();
        if (ModDebugger.skinnable) {
            BlockPos pos2 = entity.getBlockPos();
            poseStack.pushPose();
            poseStack.translate(-pos2.getX(), -pos2.getY(), -pos2.getZ());
            ShapeTesselator.stroke((IRectangle3f)((SkinnableBlockEntity)entity).getRenderShape(blockState), UIColor.ORANGE, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    public int getViewDistance() {
        return ModConfig.Client.renderDistanceBlockSkin;
    }

    @Override
    public boolean shouldRender(T entity) {
        return ((SkinnableBlockEntity)entity).isParent();
    }
}

